% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepCounter.R
\name{stepCounter2}
\alias{stepCounter2}
\title{Step Counter 2}
\usage{
stepCounter2(data, samplefreq = 100, smlen = 20L, AxesMethod = c("X", "Y",
  "Z", "XZ", "XY", "YZ", "XYZ"), ma.smooth = TRUE, filterorder = 4L,
  Peak_Threshold = 5, Central_Threshold = 0.2, Step_Threshold = 0.5,
  plot.it = FALSE, Centre = TRUE, verbose = FALSE, fun = c("GENEAcount",
  "mean", "sd", "mad"))
}
\arguments{
\item{data}{The data to use for calculating the steps. This should be a matrix
with columns time, x, y, z.}

\item{samplefreq}{The sampling frequency of the data, in hertz,
when calculating the step number (default 100).}

\item{smlen}{single integer number of data points used as a window
when counting zero crossing events}

\item{AxesMethod}{Select which axes to count the steps. \enumerate{
    \item 'X'
    \item 'Y' (default)
    \item 'Z'
    \item 'XY'
    \item 'XZ'
    \item 'YZ'
    \item 'XYZ'
}}

\item{ma.smooth}{Should a moving average filter be applied to the data.}

\item{filterorder}{Order of the moving average filter to apply to the data. This variable will be passed to \code{\link[forecast]{ma}}}

\item{Peak_Threshold}{Number of values either side of the peak/valley that are higher/lower for the value to qualify as a peak/valley}

\item{Central_Threshold}{After the signal has been centred around 0}

\item{Step_Threshold}{The difference between a peak, valley then peak or valley, peak then valley to constitute a step.}

\item{plot.it}{single logical create plot of data and peak/valley detection points (default \code{FALSE}).}

\item{Centre}{If Centre set to true (default) then the step counter zeros the xz series before filtering.}

\item{verbose}{single logical should additional progress reporting be printed at the console? (default FALSE).}

\item{fun}{character vector naming functions by which to summarize steps.
"count" is an internally implemented summarizing function that returns step count.}
}
\value{
Returns a vector with length fun.
}
\description{
Second Step counting method that uses the Peak and Valley detector after a moving average has been applied to the data.
}
\examples{
d1 <- matrix(c(100, 101, -0.79, -0.86,
        -0.17, -0.14, 0.53, 0.46),
    nrow = 2, ncol = 4)
stepCounter(data = d1, stepmethod = "longrun")
}
