% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.bic.PTReg.R
\name{predict.bic.PTReg}
\alias{predict.bic.PTReg}
\title{Make predictions from a "bic.PTReg" object}
\usage{
\method{predict}{bic.PTReg}(object, newE, newG, ...)
}
\arguments{
\item{object}{Fitted \code{"bic.PTReg"} object.}

\item{newE}{Matrix of new values for \code{E} at which predictions are to be
made.}

\item{newG}{Matrix of new values for \code{G} at which predictions are to be
made.}

\item{\dots}{Not used. Other arguments to predict.}
}
\value{
The object returned depends on the \dots{} argument which is passed
on to the \code{predict} method for \code{PTReg} objects.
}
\description{
This function makes predictions from a BIC PTReg model, using the stored \code{"bic.PTReg"}
object.  This function makes it easier to use the results of BIC to make
a prediction.
}
\references{
Yaqing Xu, Mengyun Wu, Shuangge Ma, and Syed Ejaz Ahmed.
\emph{Robust gene-environment interaction analysis using penalized trimmed regression. Journal
of Statistical Computation and Simulation, 88(18):3502-3528, 2018.}
}
\seealso{
\code{bic.PTReg}, and \code{coef}, and \code{plot} methods, and \code{PTReg}.
}
