% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertGDP.R
\name{convertGDP}
\alias{convertGDP}
\title{Convert GDP data}
\usage{
convertGDP(
  gdp,
  unit_in,
  unit_out,
  source = "wb_wdi",
  with_regions = NULL,
  replace_NAs = NULL,
  verbose = FALSE
)
}
\arguments{
\item{gdp}{A tibble, data frame or magpie object, the latter of which
requires the \href{https://github.com/pik-piam/magclass}{magclass}
package to be installed. The data-frame needs to have at least 3 columns:
\itemize{
\item a character column with iso3c
(\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{wikipedia}) country codes,
\item a numeric column with years,
\item a numeric column named "value" with GDP values.
}}

\item{unit_in}{A string with the incoming GDP unit, one of:
\itemize{
\item "current LCU"
\item "current Int$PPP"
\item "current US$MER"
\item "constant YYYY LCU"
\item "constant YYYY Int$PPP"
\item "constant YYYY US$MER"
}
where YYYY should be replaced with a year e.g. "2010" or "2017".}

\item{unit_out}{A string with the outgoing GDP unit, one of:
\itemize{
\item "current LCU"
\item "current Int$PPP"
\item "current US$MER"
\item "constant YYYY LCU"
\item "constant YYYY Int$PPP"
\item "constant YYYY US$MER"
}
where YYYY should be replaced with a year e.g. "2010" or "2017".}

\item{source}{A data frame to use for conversion factors. Can be a custom data-frame
that exists in the calling environment, or one of the package internal ones.
Use \href{https://johanneskoch94.github.io/GDPuc/reference/print_source_info.html}{print_source_info()}
to learn about the available sources.}

\item{with_regions}{NULL or a data-frame. The data-frame should be "country to region
mapping": one column named "iso3c" with iso3c country codes, and one column named
"region" with region codes to which the countries belong. Any regions in the gdp
object will then be disaggregated according to the region mapping and weighed by the
GDP share of countries in that region in the year of the unit, converted on a country
level, and re-aggregated before being returned.}

\item{replace_NAs}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
NULL, 0, 1 or "regional_average". Should countries for which conversion factors are
missing, have their NA-conversion factors replaced with 1 or with a regional average?
The default is no. If 0, then resulting NAs are simply replaced with 0. If 1, then the
missing conversion factors will be set to 1, and essentially, no conversion will take
place. If "regional_average" then, the regional average of the region to which the country
belongs to will be used. This requires a region-mapping to be passed to the function,
see the with_regions argument.}

\item{verbose}{TRUE or FALSE. A flag to turn verbosity on or off. Overrules
the GDPuc.verbose option, if it is set.}
}
\value{
The gdp argument, with the values in the "value" column, converted to unit_out.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

convertGDP() converts GDP time series data from one unit to another, using GDP
deflators, market exchange rates (MERs) and purchasing power parity
conversion factors (PPPs).
}
\details{
When providing a custom source to the function, a certain format is required.
The source object must be a data frame or tibble with at least the following columns:
\itemize{
\item a character column named "iso3c" with iso3c
(\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{wikipedia}) country codes,
\item a numeric column named "year" with years,
\item a numeric column named "GDP deflator" with values of the GDP deflator divided
by 100 (so that in the base year the GDP deflator is equal to 1, not 100).
The base year of the deflator can be any year, and can be country-specific.
\item a numeric column named "MER (LCU per US$)" with MER values,
\item a numeric column named "PPP conversion factor, GDP (LCU per international $)"
wit PPP exchange rate values.
}
}
\seealso{
The \href{https://github.com/vincentarelbundock/countrycode}{countrycode}
package to convert country codes.
}
