% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDI.R, R/extract.Qval.R, R/summary.GDINA.R
\name{Qval}
\alias{Qval}
\alias{extract.Qval}
\alias{summary.Qval}
\title{Q-matrix validation}
\usage{
Qval(GDINA.obj, method = "PVAF", eps = 0.95, digits = 4)

\method{extract}{Qval}(object, what = c("sug.Q", "varsigma", "PVAF", "eps",
  "Q"), ...)

\method{summary}{Qval}(object, ...)
}
\arguments{
\item{GDINA.obj}{An estimated model object of class \code{GDINA}}

\item{method}{which Q-matrix validation method is used?}

\item{eps}{cutoff value for PVAF. 0.95 is the default.}

\item{digits}{How many decimal places in each number? The default is 4.}

\item{object}{\code{Qval} objects for S3 methods}

\item{what}{argument for S3 method \code{extract} indicating what to extract;
It can be \code{"sug.Q"} for suggested Q-matrix,
\code{"Q"} for original Q-matrix, \code{"varsigma"} for varsigma index,
and \code{"PVAF"} for PVAF.}

\item{...}{additional arguments}
}
\value{
An object of class \code{Qval}. Elements that can be
extracted using \code{extract} method include:
\describe{
\item{sug.Q}{suggested Q-matrix}
\item{Q}{original Q-matrix}
\item{varsigma}{varsigma index}
\item{PVAF}{PVAF}
}
}
\description{
Q-matrix validation for the G-DINA model based on de la Torre and Chiu (2016).
}
\section{Methods (by generic)}{
\itemize{
\item \code{extract}: extract various elements from \code{Qval} objects

\item \code{summary}: print summary information
}}

\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ
Q[10,] <- c(0,1,0)
mod1 <- GDINA(dat = dat, Q = Q, model = "GDINA")
out <- Qval(mod1,eps = 0.95)
out
#If many entries are modified, you may want to check
#the PVAF plot using the function plotPVAF or
#to change eps. eps = 0.9 or 0.8 seems another two
#reasonable choices.
extract(out,what = "PVAF")
#See also:
extract(out,what = "varsigma")
extract(out,what = "sug.Q")

# Draw a mesa plot
mesaplot(out,item=10,type="all",no.qvector=5)
}
}
\references{
de la Torre & Chiu. (2016). A General Method of Empirical Q-matrix Validation. \emph{Psychometrika, 81}, 253-273.

de la Torre, J., & Chiu, C.-Y. (2016). A General Method of Empirical Q-matrix Validation. \emph{Psychometrika}. http://doi.org/10.1007/s11336-015-9467-8
}
\seealso{
\code{\link{GDINA}}, \code{\link{mesaplot}}
}
\author{
{Wenchao Ma, Rutgers University, \email{wenchao.ma@rutgers.edu} \cr Jimmy de la Torre, The University of Hong Kong}
}
