% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_functions.R
\name{BS_global_factor}
\alias{BS_global_factor}
\title{Get bootstrap confidence intervals for the global factors}
\usage{
BS_global_factor(object, t, BB = 599, alpha = 0.05)
}
\arguments{
\item{object}{An S3 object of class 'multi_result' created by multilevel().}

\item{t}{An integer specifying the time point at which the CI is constructed.}

\item{BB}{An integer indicating the number of bootstrap repetition. 599 by default.}

\item{alpha}{The significance level, a single numeric between 0 and 1. 0.05 by default.}
}
\value{
A matrix containing the upper and lower band.
}
\description{
This function employs a bootstrap procedure to obtain confidence intervals
for the global factors at time \eqn{t}.
}
\examples{

\donttest{
panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
bs_global_mid <- BS_global_factor(est_multi, t = est_multi$T / 2)
}
}
