% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{Simulation}
\alias{Simulation}
\title{'Simulation' contains several methods to simulate 'TrapezoidalFuzzyNumberLists'.}
\description{
Simulation contains 5 different methods that gives the user a 'TrapezoidalFuzzyNumberList'.
}
\note{
In case you find (almost surely existing) bugs or have recommendations
for improving the method comments are welcome to the below mentioned mail addresses.
}
\examples{

## ------------------------------------------------
## Method `Simulation$simulCase1`
## ------------------------------------------------

Simulation$new()$simulCase1(10L)

## ------------------------------------------------
## Method `Simulation$simulCase2`
## ------------------------------------------------

Simulation$new()$simulCase2(10L)

## ------------------------------------------------
## Method `Simulation$simulCase3`
## ------------------------------------------------

Simulation$new()$simulCase3(10L)

## ------------------------------------------------
## Method `Simulation$simulCase4`
## ------------------------------------------------

Simulation$new()$simulCase4(10L)

## ------------------------------------------------
## Method `Simulation$simulFRSTra`
## ------------------------------------------------

Simulation$new()$simulFRSTra(100L,0.05,0.35,0.6,2,1)
}
\references{
[1] De la Rosa de Saa, S.; Gil, M.A.; Gonzalez-Rodriguez, G.; Lopez, M.T.; Lubiano M.A.: Fuzzy
rating scale-based questionnaires and their statistical analysis, IEEE Transactions on Fuzzy
Systems 23(1), 111-126 (2015)

[2] Lubiano, M.A.; Salas, A.; Carleos, C.; De la Rosa de Sáa, S.; Gil, M.Á.: Hypothesis
testing-based comparative analysis between rating scales for intrinsically imprecise data,
International Journal of Approximate Reasoning 88, 128-147 (2017)

[3] Sinova, B.; Gil, M.A.; Colubi, A.; Van Aelst, S.: The median of a random fuzzy number. The
1-norm distance approach, Fuzzy Sets and Systems 200, 99-115 (2012)

[4] Sinova, B.; Gil, M.A.; Van Aelst, S.: M-estimates of location for the robust central tendency of
fuzzy data, IEEE Transactions on Fuzzy Systems 24(4), 945-956 (2016)
}
\author{
(s) Andrea Garcia Cernuda <uo270115@uniovi.es>, Asun Lubiano <lubiano@uniovi.es>,
Sara de la Rosa de Saa
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Simulation-simulCase1}{\code{Simulation$simulCase1()}}
\item \href{#method-Simulation-simulCase2}{\code{Simulation$simulCase2()}}
\item \href{#method-Simulation-simulCase3}{\code{Simulation$simulCase3()}}
\item \href{#method-Simulation-simulCase4}{\code{Simulation$simulCase4()}}
\item \href{#method-Simulation-simulFRSTra}{\code{Simulation$simulFRSTra()}}
\item \href{#method-Simulation-clone}{\code{Simulation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-simulCase1"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-simulCase1}{}}}
\subsection{Method \code{simulCase1()}}{
This method generates n 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList'
from a symmetric distribution and with independent components (for a detailed
explanation of the simulation see Sinova et al. (2012) [3], namely, the Case 1 for
noncontaminated samples).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$simulCase1(n = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{positive integer. It is the number of trapezoidal fuzzy numbers to
be generated.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a TrapezoidalFuzzyNumberList with n TrapezoidalFuzzyNumbers. Each
one is characterized by its four values inf0, inf1, sup1, sup0.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Simulation$new()$simulCase1(10L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-simulCase2"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-simulCase2}{}}}
\subsection{Method \code{simulCase2()}}{
This method generates n 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList'
from a symmetric distribution and with dependent components (for a detailed
explanation of the simulation see Sinova et al. (2012) [3], namely, the Case 2
for noncontaminated samples).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$simulCase2(n = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{positive integer. It is the number of trapezoidal fuzzy numbers to
be generated.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a TrapezoidalFuzzyNumberList with n TrapezoidalFuzzyNumbers. Each
one is characterized by its four values inf0, inf1, sup1, sup0.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Simulation$new()$simulCase2(10L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-simulCase3"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-simulCase3}{}}}
\subsection{Method \code{simulCase3()}}{
This method generates n 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList'
from a asymmetric distribution and with independent components (for a detailed
explanation of the simulation see Sinova et al. (2012) [4], namely, the Case 3
for noncontaminated samples).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$simulCase3(n = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{positive integer. It is the number of trapezoidal fuzzy numbers to
be generated.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a TrapezoidalFuzzyNumberList with n TrapezoidalFuzzyNumbers. Each
one is characterized by its four values inf0, inf1, sup1, sup0.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Simulation$new()$simulCase3(10L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-simulCase4"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-simulCase4}{}}}
\subsection{Method \code{simulCase4()}}{
This method generates n 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList'
from a asymmetric distribution and with dependent components (for a detailed
explanation of the simulation see Sinova et al. (2012) [4], namely, the Case 4
for noncontaminated samples).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$simulCase4(n = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{positive integer. It is the number of trapezoidal fuzzy numbers to
be generated.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a TrapezoidalFuzzyNumberList with n TrapezoidalFuzzyNumbers. Each
one is characterized by its four values inf0, inf1, sup1, sup0.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Simulation$new()$simulCase4(10L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-simulFRSTra"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-simulFRSTra}{}}}
\subsection{Method \code{simulFRSTra()}}{
This method generates n 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList'
based on the fuzzy rating scale. They are simulated mimicking the human behavior,
considering for it a finite mixture of three different procedures (for a
detailed explanation of the simulation see De la Rosa de Saa et al. (2012) [1]), and
generated in the interval [0,1].
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$simulFRSTra(n = NA, w1 = NA, w2 = NA, w3 = NA, p = NA, q = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{positive integer. It is the number of trapezoidal fuzzy numbers to
be generated.}

\item{\code{w1}}{real number in [0,1]. It should be fulfilled that w1+w2+w3=1.}

\item{\code{w2}}{real number in [0,1]. It should be fulfilled that w1+w2+w3=1.}

\item{\code{w3}}{real number in [0,1]. It should be fulfilled that w1+w2+w3=1.}

\item{\code{p}}{real number > 0. It is the first parameter of the beta distribution.}

\item{\code{q}}{real number > 0. It is the second parameter of the beta distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a TrapezoidalFuzzyNumberList with n TrapezoidalFuzzyNumbers with
values in the interval [0,1]. Each trapezoidal fuzzy rating response is
characterized by its four values inf0, inf1, sup1, sup0.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Simulation$new()$simulFRSTra(100L,0.05,0.35,0.6,2,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
