% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyOperation.R
\name{x.fuzzification}
\alias{x.fuzzification}
\title{Fuzzification}
\usage{
x.fuzzification(fuzzification.method, x, mf.params)
}
\arguments{
\item{fuzzification.method}{The fuzzification method}

\item{x}{The required parameters for a fuzzification method}

\item{mf.params}{The parameters for a membership function}
}
\value{
The corresponding fuzzy membership function
}
\description{
To convert the crisp input x to a fuzzy membership function with specified fuzzification method
}
\examples{
x <- 3
mf <- x.fuzzification(gbell.fuzzification, x, c(1,2))
# This is the same as:
mf <- genmf(gbellmf, c(1,2,x))

evalmf(1:10, mf)
}
\author{
Chao Chen
}
