% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.fbd.R
\name{sim.fbd.rateshift.taxa}
\alias{sim.fbd.rateshift.taxa}
\title{sim.fbd.rateshift.taxa: Simulating fossilized birth death trees incorporating rate shifts.}
\usage{
sim.fbd.rateshift.taxa(n, numbsim, lambda, mu, psi, times,
  complete = FALSE)
}
\arguments{
\item{n}{Number of extant sampled tips.}

\item{numbsim}{Number of trees to simulate.}

\item{lambda}{Vector of speciation rates, the rate in entry i
is the speciation rate prior (ancestral) to time times[i].}

\item{mu}{Vector of extinction rates, the rate in entry i
is the extinction rate prior (ancestral) to time times[i].}

\item{psi}{Vector of fossil sampling rates, the rate in entry i
is the fossil sampling rate prior (ancestral) to time times[i].}

\item{times}{Vector of mass extinction and rate shift times.
Time is 0 today and increasing going backwards in time. Specify the vector as times[i]}

\item{complete}{If TRUE, the tree including the extinct lineages and
non-sampled lineages is returned (so the tree has
round(n/frac[1]) extant tips). If FALSE, the extinct lineages
and non-sampled lineages are suppressed.}
}
\value{
List of numbsim simulated SAtrees with n extant sampled tips.
}
\description{
sim.fbd.rateshift.taxa: Simulating fossilized birth death trees incorporating rate shifts.
}
\examples{
n = 10
numbsim = 1
sim.fbd.rateshift.taxa(n,numbsim, lambda = c(2,1), mu = c(0,0.3), psi = c(1,0.1), times = c(0.3))
}
\keyword{birth}
\keyword{death}
\keyword{fossilized}
