% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_bavrn_state_short.R
\name{validate_fe_species_bavrn_state_short}
\alias{validate_fe_species_bavrn_state_short}
\title{Validate an \emph{fe_species_bavrn_state_short} Object}
\usage{
validate_fe_species_bavrn_state_short(x = character())
}
\arguments{
\item{x}{An object that is expected to be a valid
\code{fe_species_bavrn_state_short} object}
}
\value{
Returns \code{x}, but this function is mainly called for its side
effect which is pointing out any violations of the
\code{fe_species_bavrn_state_short} object specifications. In case of such
violations, the function will terminate with an error.
}
\description{
Regular users will not require this function. Expert users will want to use
it in combination with the constructor
\code{\link{fe_species_bavrn_state_short}}. Regular users, please construct
\code{fe_species_bavrn_state_short} objects with
\code{\link{fe_species_bavrn_state_short}}.
}
\examples{
# Passes validation
spec_ids <- as.character(c(3, 3, 3, 1, 1, 1, 1, 2, 2, 8))
spec_ids <- new_fe_species_bavrn_state_short(spec_ids)
validate_fe_species_bavrn_state_short(spec_ids)

# Validating the following spec_ids throws an error due to
# non-supported species codes
spec_ids <- as.character(c(3, 3, 8712, 1, 1, 1, 349, 2, 2, 8))
spec_ids <- new_fe_species_bavrn_state_short(spec_ids)
try(
  validate_fe_species_bavrn_state_short(spec_ids)
)

}
