% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stand_sums_dynamic.R
\name{stand_sums_dynamic}
\alias{stand_sums_dynamic}
\title{stand_sums_dynamic}
\usage{
stand_sums_dynamic(x, tree_filter = TRUE)
}
\arguments{
\item{x}{An \code{\link{fe_stand}} object}

\item{tree_filter}{A \code{data-masking} expression that applies to the
data.frame \code{x$trees}. It must return a logical value, and is defined
in terms of the variables in \code{x$trees}. In this function, it is used
internally in order to define the cohort of trees which is to be evaluated
by this function (within a call to \code{dplyr::filter()}). In order to
obtain meaningful increments, you should be very careful when changing
the default value (\code{TRUE}) of \code{tree_filter}.}
}
\value{
A data frame (tibble) that contains the periodic annual basal area
and volume growth (the latter if enough information is available,
see Details) per ha for each species and each period. The year where the
increment entry is, means the end point of the period of interest.
Therefore, the first increment value will always be NA. If the input
\code{\link{fe_stand}} object \code{x} does only comprise one survey, the
increment values will be NA, because it takes at least two subsequent
surveys to calculate meaningful increments. In case an object of class
\code{fe_ccircle_spatial_notrees} (which is a special child of
\code{\link{fe_stand}}) is provided as input \code{x}, the function returns
an empty data frame.
}
\description{
Calculate periodic annual volume and basal area increments for
\code{\link{fe_stand}} objects with repeated surveys
}
\details{
For the sake of robustness, \code{stand_sums_dynamic} does not perform a
plausibility check on single tree level before calculating increments.
Internally, the function \code{\link{stand_sums_static}} is called separately
for the remaining and the removal stand. Both are required for calculating
meaningful increments. Basal area increments are always calculated, because
valid \code{\link{fe_stand}} objects always contain the required information
(i.e. all trees' dbh); volume increments are calculated if also height values
(either measured or estimated) are available for all trees.
}
\examples{
  oo <- options(fe_spec_lang = "eng") # Display species names in English

  # Mixed mountain forest with several surveys
  stand_inc <- stand_sums_dynamic(mm_forest_1_fe_stand_spatial)
  stand_inc

  # Combine to species overarching increments. Zero in the first year results
  # as there cannot be increments available at the first survey
  stand_inc |>
    dplyr::group_by(time_yr) |>
      dplyr::summarise(
        iba_m2_ha_yr = sum(iba_m2_ha_yr, na.rm = TRUE),
        iv_m3_ha_yr  = sum(iv_m3_ha_yr,  na.rm = TRUE)
      )

  # When there is only one single survey, all increments must be NA
  stand_sums_dynamic(spruce_beech_1_fe_stand)

  options(oo) # Set options to previous values

}
