% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_weightvector.R
\name{initialize_weightvector}
\alias{initialize_weightvector}
\title{Initialize weightvector for iterative ForeCA algorithms}
\usage{
initialize_weightvector(U = NULL, f.U = NULL, num.series = ncol(U),
  method = c("rnorm", "max", "SFA", "PCA", "rcauchy", "runif", "SFA.slow",
  "SFA.fast", "PCA.large", "PCA.small"), seed = sample(1e+06, 1), ...)
}
\arguments{
\item{U}{a \eqn{T \times K} array with \code{T} observations from the 
\eqn{K}-dimensional \strong{whitened} (\code{\link{whiten}}) 
time series \eqn{\mathbf{U}_t}. Can be a \code{matrix}, \code{data.frame}, or a 
multivariate \code{ts} object.}

\item{f.U}{multivariate spectrum of class \code{'mvspectrum'} with 
\code{normalize = TRUE}.}

\item{num.series}{positive integer; number of time series \eqn{K} (determines the length 
of the weightvector). If \code{num.series = 1} it simply returns
a 1 \eqn{\times} 1 array equal to \code{1}.}

\item{method}{string; which heuristics should be used to generate a good starting \eqn{\mathbf{w}_0}?
Default: \code{"rnorm"}; see Details.}

\item{seed}{non-negative integer; seed for random initialization which will be 
returned for reproducibility. By default it sets a random seed.}

\item{...}{additional arguments}
}
\value{
numeric; a vector of length \eqn{K} with unit norm in \eqn{\ell^2}.
}
\description{
\code{initialize_weightvector} returns a unit norm (in \eqn{\ell^2})
vector \eqn{\mathbf{w}_0 \in R^K} that can be used as the starting
point for any iterative ForeCA algorithm, e.g., 
\code{\link{foreca.EM.one_weightvector}}. Several 
quickly computable heuristics are available via the \code{method} argument.
}
\details{
The \code{method} argument specifies the heuristics that is used to get a good
starting vector \eqn{\mathbf{w}_0}:

\itemize{
 \item{\code{"max"}}{ vector with all \eqn{0}s, but a \eqn{1} at the position
 of the maximum forecastable series in \code{U}.}
 \item{\code{"rcauchy"}}{ random start using \code{rcauchy(k)}.}
 \item{\code{"rnorm"}}{ random start using \code{rnorm(k, 0, 1)}.}
 \item{\code{"runif"}}{ random start using \code{runif(k, -1, 1)}.}
 \item{\code{"PCA.large"}}{ first eigenvector of PCA (largest variance signal).}
 \item{\code{"PCA.small"}}{ last eigenvector of PCA (smallest variance signal).}
 \item{\code{"PCA"}}{ checks both small and large, and chooses the one with higher
            forecastability as computed by \code{\link{Omega}}..}
 \item{\code{"SFA.fast"}}{ last eigenvector of SFA (fastest signal).}
 \item{\code{"SFA.slow"}}{ first eigenvector of SFA (slowest signal).}
 \item{\code{"SFA"}}{ checks both slow and fast, and chooses the one with higher
            forecastability as computed by \code{\link{Omega}}.}
} 

Each vector has length K and is automatically normalized to have unit norm 
in \eqn{\ell^2}.

For the \code{'SFA*'} methods see \code{\link{sfa}}. 
Note that maximizing (or minimizing) the lag \eqn{1} auto-correlation does 
not necessarily yield the most forecastable signal, but it's a good start.
}
\examples{
XX <- diff(log(EuStockMarkets))
\dontrun{
initialize_weightvector(U = XX, method = "SFA")
}
initialize_weightvector(num.series = ncol(XX), method = "rnorm")
}
\keyword{manip}

