% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thfrec.R
\name{thfrec}
\alias{thfrec}
\title{Forecast reconciliation through temporal hierarchies (temporal reconciliation)}
\usage{
thfrec(basef, m, comb, res, mse = TRUE, corpcor = FALSE, Omega,
       type = "M", sol = "direct", nn = FALSE, keep = "list",
       settings = osqpSettings(verbose = FALSE, eps_abs = 1e-5,
       eps_rel = 1e-5, polish_refine_iter = 100, polish=TRUE))
}
\arguments{
\item{basef}{Vector of base forecasts to be reconciled, containing the forecasts
at all the needed temporal frequencies ordered as [lowest_freq' ...  highest_freq']'.}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order of temporal aggregation).}

\item{comb}{Type of the reconciliation. Except for bottom up, all other options
correspond to a different (\code{(k* + m) x (k* + m)}) covariance matrix,
\code{k*} is the sum of (\code{p-1}) factors of \code{m} (excluding \code{m}):
\itemize{
  \item \bold{bu} (Bottom-up);
  \item \bold{ols} (Identity);
  \item \bold{struc} (Structural variances);
  \item \bold{wlsv} (Series variances);
  \item \bold{wlsh} (Hierarchy variances);
  \item \bold{acov} (Auto-covariance matrix);
  \item \bold{strar1} (Structural Markov);
  \item \bold{sar1} (Series Markov);
  \item \bold{har1} (Hierarchy Markov);
  \item \bold{shr} (Shrunk cross-covariance matrix);
  \item \bold{sam} (Sample cross-covariance matrix);
  \item \bold{omega} use your personal matrix Omega in param \code{Omega}.
}}

\item{res}{vector containing the in-sample residuals at all the temporal frequencies
ordered as \code{basef}, i.e. [lowest_freq' ...  highest_freq']', needed to
estimate the covariance matrix when \code{comb =} \code{\{"wlsv",} \code{"wlsh",}
\code{"acov",} \code{"strar1",} \code{"sar1",} \code{"har1",}
\code{"shr",} \code{"sam"\}}.}

\item{mse}{Logical value: \code{TRUE} (\emph{default}) calculates the
covariance matrix of the in-sample residuals (when necessary) according to the original
\pkg{hts} and \pkg{thief} formulation: no mean correction, T as denominator.}

\item{corpcor}{Logical value: \code{TRUE} if \pkg{corpcor} (\enc{Schäfer}{Schafer} et
al., 2017) must be used to shrink the sample covariance matrix according to
\enc{Schäfer}{Schafer} and Strimmer (2005), otherwise the function uses the same
implementation as package \pkg{hts}.}

\item{Omega}{This option permits to directly enter the covariance matrix:
\enumerate{
  \item \code{Omega} must be a p.d. (\code{(k* + m) x (k* + m)}) matrix;
  \item if \code{comb} is different from "\code{omega}", \code{Omega} is not used.
}}

\item{type}{Approach used to compute the reconciled forecasts: \code{"M"} for
the projection approach with matrix M (\emph{default}), or \code{"S"} for the
structural approach with summing matrix S.}

\item{sol}{Solution technique for the reconciliation problem: either \code{"direct"} (\emph{default}) for the direct
solution or \code{"osqp"} for the numerical solution (solving a linearly constrained quadratic
program using \code{\link[osqp]{solve_osqp}}).}

\item{nn}{Logical value: \code{TRUE} if non-negative reconciled forecasts are wished.}

\item{keep}{Return a list object of the reconciled forecasts at all levels.}

\item{settings}{Settings for \pkg{osqp} (object \code{\link[osqp]{osqpSettings}}). The default options
are: \code{verbose = FALSE}, \code{eps_abs = 1e-5}, \code{eps_rel = 1e-5},
\code{polish_refine_iter = 100} and \code{polish = TRUE}. For details, see the
\href{https://osqp.org/}{\pkg{osqp} documentation} (Stellato et al., 2019).}
}
\value{
If the parameter \code{keep} is equal to \code{"recf"}, then the function
returns only the reconciled forecasts vector, otherwise (\code{keep="all"})
it returns a list that mainly depends on what type of representation (\code{type})
and methodology (\code{sol}) have been used:
\item{\code{recf}}{(\code{h(k* + m) x 1}) reconciled forecasts vector.}
\item{\code{Omega}}{Covariance matrix used for forecast reconciliation.}
\item{\code{nn_check}}{Number of negative values (if zero, there are no values below zero).}
\item{\code{rec_check}}{Logical value: has the hierarchy been respected?}
\item{\code{M} (\code{type="M"} and \code{type="direct"})}{Projection matrix (projection approach)}
\item{\code{G} (\code{type="S"} and \code{type="direct"})}{Projection matrix (structural approach).}
\item{\code{S} (\code{type="S"} and \code{type="direct"})}{Temporal summing matrix, \strong{R}.}
\item{\code{info} (\code{type="osqp"})}{matrix with some useful indicators (columns)
for each forecast horizon \code{h} (rows): run time (\code{run_time}) number of iteration,
norm of primal residual (\code{pri_res}), status of osqp's solution (\code{status}) and
polish's status (\code{status_polish}).}

Only if \code{comb = "bu"}, the function returns \code{recf}, \code{S} and \code{M}.
}
\description{
Forecast reconciliation of one time series through temporal hierarchies
(Athanasopoulos et al., 2017). The reconciled forecasts are calculated
either through a projection approach (Byron, 1978), or the equivalent
structural approach by Hyndman et al. (2011). Moreover, the classic
bottom-up approach is available.
}
\details{
In case of non-negativity constraints, there are two ways:
\enumerate{
  \item \code{sol = "direct"} and \code{nn = TRUE}: the base forecasts
  will be reconciled at first without non-negativity constraints, then, if negative reconciled
  values are present, the \code{"osqp"} solver is used.
  \item \code{sol = "osqp"} and \code{nn = TRUE}: the base forecasts will be
  reconciled through the \code{"osqp"} solver.
}
}
\examples{
data(FoReco_data)
# top ts base forecasts ([lowest_freq' ...  highest_freq']')
topbase <- FoReco_data$base[1, ]
 # top ts residuals ([lowest_freq' ...  highest_freq']')
topres <- FoReco_data$res[1, ]
obj <- thfrec(topbase, m = 12, comb = "acov", res = topres)

}
\references{
Athanasopoulos, G., Hyndman, R.J., Kourentzes, N., Petropoulos, F. (2017),
Forecasting with Temporal Hierarchies, \emph{European Journal of Operational
Research}, 262, 1, 60-74.

Byron, R.P. (1978), The estimation of large social accounts matrices,
\emph{Journal of the Royal Statistical Society A}, 141, 3, 359-367.

Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.

Hyndman, R.J., Ahmed, R.A., Athanasopoulos, G., Shang, H.L. (2011), Optimal combination
forecasts for hierarchical time series, \emph{Computational Statistics & Data
Analysis}, 55, 9, 2579-2589.

Nystrup, P.,  \enc{Lindström}{Lindstrom}, E., Pinson, P., Madsen, H. (2020),
Temporal hierarchies with autocorrelation for load forecasting,
\emph{European Journal of Operational Research}, 280, 1, 876-888.

\enc{Schäfer}{Schafer}, J.L., Opgen-Rhein, R., Zuber, V., Ahdesmaki, M.,
Duarte Silva, A.P., Strimmer, K. (2017), Package `corpcor', R
package version 1.6.9 (April 1, 2017), \href{https://CRAN.R-project.org/package=corpcor}{https://CRAN.R-project.org/package= corpcor}.

\enc{Schäfer}{Schafer}, J.L., Strimmer, K. (2005), A Shrinkage Approach to Large-Scale Covariance
Matrix Estimation and Implications for Functional Genomics, \emph{Statistical
Applications in Genetics and Molecular Biology}, 4, 1.

Stellato, B., Banjac, G., Goulart, P., Bemporad, A., Boyd, S. (2018). OSQP:
An Operator Splitting Solver for Quadratic Programs, \href{https://arxiv.org/abs/1711.08013}{arXiv:1711.08013}.

Stellato, B., Banjac, G., Goulart, P., Boyd, S., Anderson, E. (2019), OSQP:
Quadratic Programming Solver using the 'OSQP' Library, R package version 0.6.0.3
(October 10, 2019), \href{https://CRAN.R-project.org/package=osqp}{https://CRAN.R-project.org/package=osqp}.
}
\keyword{reconciliation}
