% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather.R
\name{NOAA_allStations}
\alias{NOAA_allStations}
\alias{NOAA_countryStations}
\title{Get list of weather stations from NOAA}
\usage{
NOAA_allStations(force_retrieve = FALSE)

NOAA_countryStations(fips, from = NULL, to = NULL)
}
\arguments{
\item{force_retrieve}{If \code{TRUE} download the list again from NOAA (even if
it was already downloaded previously). Defaults to \code{FALSE}, so that download
happens only once per session.}

\item{fips}{2-letter country FIPS ID (full list of codes at
\url{ftp://ftp.ncdc.noaa.gov/pub/data/gsod/country-list.txt}).}

\item{from}{Lower limit of reporting period (as class \code{Date}). Only retrieve
stations whose period of record ends at or after this date.}

\item{to}{Upper limit of reporting period (as class \code{Date}). Only retrieve
stations whose period of record begins at or before this date.}
}
\value{
A \code{data.frame} with the following columns (copy-pasted from NOAA):
  \describe{
    \item{usaf}{Air Force station ID. May contain a letter in the first position.}
    \item{wban}{NCDC WBAN number}
    \item{ctry}{FIPS country ID}
    \item{st}{State for US stations}
    \item{icao}{ICAO ID}
    \item{lat}{Latitude in thousandths of decimal degrees}
    \item{lon}{Longitude in thousandths of decimal degrees}
    \item{elev.m.}{Elevation in meters}
    \item{begin}{Beginning Period Of Record. There may be reporting gaps within the P.O.R.}
    \item{end}{Ending Period Of Record. There may be reporting gaps within the P.O.R.}
  }

Note that columns \code{begin} and \code{end} in the output are of class \code{Date}.
}
\description{
Download the list of all available weather stations from NOAA, or only those for
a specific country and period
}
\details{
\code{NOAA_allStations()} downloads the list of all available weather
stations from NOAA, found in
\url{ftp://ftp.ncdc.noaa.gov/pub/data/noaa/isd-history.csv}, and returns it
as a \code{data.frame}. The data are downloaded only once per R session,
the first time this function is used, and are then stored internally for
further retrievals.

\code{NOAA_countryStations()} retrieves the list for a specific country only
(or several countries, if \code{length(ctry)>1}), and possibly only for a specific
period of record.
}
