#' Greece mortality and influenza data
#'
#' Surveillance data from Greece used to estimate influenza-attributable
#' mortality using FluMoDL, covering the period from May 2013 to October 2017.
#' Contains the following:
#' * A daily time series of (all-cause) deaths
#' * A time series of daily mean temperatures
#' * A weekly series of Influenza-Like Illness (ILI) rates, calculated via
#' sentinel surveillance
#' * Three weekly series of laboratory sample percentage positives by influenza
#' type and subtype: A(H1N1)pdm09, A(H3N2) and B. These can be multiplied with
#' the respective ILI rates, to create type-specific influenza incidence proxies
#' (see Goldstein et al.
#' \href{https://journals.plos.org/plosmedicine/article?id=10.1371/journal.pmed.1001051}{PLoS Med.}
#' 2011;8(7):e1001051)
#'
#' @docType data
#'
#' @usage data(greece)
#'
#' @format An list with two elements of class \code{`data.frame`}: `greece$daily`
#' contains a \code{`data.frame`} with columns `date` (of class \code{`Date`}),
#' `deaths` and `temperature`. `greece$weekly` contains a \code{`data.frame`}
#' with columns `yearweek` (integer, in YYYYWW format), `ILI` (ILI rate per
#' 1000 patient consultations), `ppH1`, `ppH3` and `ppB` (percentage positives
#' for A(H1N1)pdm09, A(H3N2) and B respectively).
#'
#' @keywords datasets
#'
#' @references
#' Lytras T, Pantavou K, Mouratidou E, Tsiodras S. Mortality attributable to seasonal influenza
#' in Greece, 2013 to 2017: variation by type/subtype and age, and a possible harvesting effect.
#' \href{https://www.eurosurveillance.org/content/10.2807/1560-7917.ES.2019.24.14.1800118}{Euro Surveill.}
#' 2019;24(14):pii=1800118 (\href{https://www.ncbi.nlm.nih.gov/pubmed/30968823}{PubMed})
#'
#' @source Greek \href{https://eody.gov.gr/en/}{National Public Health
#' Organization} (formerly the Hellenic Centre for Disease Control and Prevention)
#'
#' @examples
#' data(greece)
#' str(greece$daily)
#' str(greece$weekly)
"greece"
