% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicted_residuals.R
\name{residuals.flexreg}
\alias{residuals.flexreg}
\title{Residuals Method for flexreg Objects}
\usage{
\method{residuals}{flexreg}(
  object,
  type = "raw",
  cluster = FALSE,
  estimate = "mean",
  q = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{`flexreg`}, usually the result of \code{\link{flexreg}}.}

\item{type}{a character indicating type of residuals (\code{raw} or \code{standardized}).}

\item{cluster}{a logical. If the model is \code{"FB"}, \code{cluster=T} returns the cluster means. Default \code{cluster = F}.}

\item{estimate}{the type of estimate: \code{mean} (default), \code{median} or \code{quantile}.}

\item{q}{if estimate is \code{quantile}, a numeric value of probability in (0, 1).}

\item{...}{additional arguments. Currently not used.}
}
\description{
Method that computes various types of residuals from objects of class \code{`flexreg`}. If the model type is \code{FB} and \code{cluster = T}, the method returns also residuals with respect to cluster means.
}
\details{
Raw residuals are defined as \eqn{y_i-\hat{\mu}_i}
for \eqn{i=1, \dots, n}. The values \eqn{y_i} for \eqn{i,\dots,n} are referred to the observed
response variable and they are specified on the left-hand side of \code{formula} in the
\code{\link{flexreg}} function.
\eqn{\hat{\mu}_i} for \eqn{i=1, \dots, n} is the predicted mean. It can be computed separately
 through the \code{\link{predict}} function by setting \code{type=response}.
Standardized residuals are defined as \eqn{\frac{y_i-\hat{\mu}_i}{\hat{Var}(y_i)}} where
 \eqn{\hat{Var}(y_i)}
is the variance of the dependent variable evaluated at the posterior means
(default, otherwise quantile of order q) of the parameters.
If the model is \code{"FB"} and \code{cluster=T}, the cluster residuals are computed as
the difference between the observed response variable and the cluster means
\eqn{\hat{\lambda}_{1i}} and \eqn{\hat{\lambda}_{2i}} for \eqn{i=1, \dots, n}.
}
\examples{
{
data("Reading")
FB <- flexreg(accuracy ~ iq, Reading, type="FB", n.iter=1000)
residuals(FB, type="raw", cluster=TRUE)
}

}
\references{
{
Migliorati, S., Di Brisco, A. M., Ongaro, A. (2018) A New Regression Model for Bounded Responses. Bayesian Analysis, \bold{13}(3), 845--872. doi:10.1214/17-BA1079
}
}
