% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R
\docType{class}
\name{Rule}
\alias{Rule}
\title{Class "Rule"}
\description{
Class to manage a \link{Fis} rule
}
\section{Fields}{

\describe{
\item{\code{premises}}{\link{integer} vector, The premises of the rule\cr
A premise is the 1-based index of MF in the \link{FisIn}\cr
0 means the input is not taken into account for this rule, i.e. the rule is incomplete\cr
The vector length must be equal to the number of inputs in the \link{Fis}}

\item{\code{conclusions}}{\link{numeric} vector, The conclusions of the rule\cr
A conclusion is a \link{numeric} value for crisp output \link{FisOutCrisp}, or the 1-based index of MF in the fuzzy output \link{FisOutFuzzy}\cr
The vector length must be equal to the number of outputs in the \link{Fis}}
}}

\section{Constructors}{

\describe{
\item{\code{Rule()}}{
The default constructor to build an empty rule\cr
The rule is initialized with empty premises and conclusions
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{Rule} object}
}}

\item{\code{Rule(premises, conclusions)}}{
The constructor to build a rule
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{premises}}{\link{integer} vector, The premises of the rule (the vector length must be equal to the number of inputs in the \link{Fis})}
\item{argument: \code{conclusions}}{\link{numeric} vector, The conclusions of the rule (the vector length must be equal to the number of outputs in the \link{Fis})}
\item{return:}{\link{Rule} object}
}}}
}

\examples{
rule1 <- NewRule()
rule1$premises <- c(1, 2, 0)
rule1$conclusions <- c(1, 2)

rule2 <- NewRule(c(2, 1, 1), c(2, 1))
}
\seealso{
{
\link{NewRule}

\href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}
}
}
