% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01.firm_query.R
\name{query.firms.dataframe}
\alias{query.firms.dataframe}
\title{Function to extract information from multiple \code{firm} object (legal person) as a data frame}
\usage{
query.firms.dataframe(..., which, naming = TRUE, transposing = TRUE)
}
\arguments{
\item{...}{Object/s which to extract information from (see 'Details')}

\item{which}{Information to extract, minimum unambiguous sub-string. Possible values (one or more):
- \code{name} Name of the firm
- \code{id} ID of the firm, usually the ticker (if provided or otherwise known)
- \code{legal_form} Legal form of the firm
- \code{sector} Sector in which the firm operates
- \code{revenues} Yearly revenues
- \code{capitalisation} Capitalisation
- \code{management} Members of the board
- \code{ownership} Owner(s)
- \code{shares} Share owned by (each of) the owner(s)
- \code{currency} Currency in which revenues and capitalisation are denominated}

\item{naming}{Whether to name the result after the queried information (defaults to \code{TRUE})}

\item{transposing}{If \code{TRUE} (default) each row will correspond to a firm and each column to a variable.}
}
\value{
A data frame in structured as follows (or vice versa if \code{transposing == TRUE}):
\describe{
 \item{a row}{for each queried information; and}
 \item{a column}{for each number of firm}.
}
}
\description{
This function can be fed either:
- a (possibly named) \code{\link{list}} of objects of class \code{firm} (see example 1); or
}
\details{
It is not recommended to use this function with \code{management}, \code{ownership}, or \code{shares} unless \code{transposing == FALSE}.
}
\examples{
\donttest{
# Query Apple's, GM's, and BTI's market cap and revenues
data('firms_US')
query.firms.dataframe(firms_US, which = c('cap', 'rev'))

# Query GM's and BTI's market cap and revenues
data('firms_US')
list2env(firms_US, envir = parent.frame())
query.firms.dataframe(GM, BTI, which = c('cap', 'rev'))
}

}
\seealso{
\link{query.firm} \link{query.firms}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
