% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05.network&graph.R
\name{get.net}
\alias{get.net}
\title{Create any firm-firm (FF) network}
\usage{
get.net(
  x,
  vertex.size = NULL,
  vertex.colour = NULL,
  edge.width = NULL,
  edge.greyscale = NULL,
  format = c("igraph", "network"),
  directed = TRUE,
  loops = FALSE,
  weighted = any(x@M \%in\% c(0, 1)),
  ...
)
}
\arguments{
\item{x}{A matrix-like object produced by \code{\link{FF}} and related functions}

\item{vertex.size}{Which piece of information on the firms should be used to represent the nodes' size (see Details).}

\item{vertex.colour}{Which piece of  information on the firms should be used to represent the nodes' colours (see Details).}

\item{edge.width}{Whether to use the edges' width to represent tie strength. Defaults to \code{FALSE}.}

\item{edge.greyscale}{Whether to use the edges' colour to represent tie strength through a grey scale. Defaults to \code{TRUE} if the matrix is valued.}

\item{format}{Which format to use for the network. Possible values: \code{igraph} or \code{network}}

\item{directed}{Whether the network should be directed. Defaults to \code{TRUE}}

\item{loops}{Whether the network should have loops. Defaults to \code{FALSE}}

\item{weighted}{Whether the ties/edges should be weighted. Defaults to \code{TRUE} if any element of the matrix equals neither 0 nor 1}

\item{...}{Aliases to the other parameters and additional settings (see Details).}
}
\value{
A network in the desired format
}
\description{
Create a network (either an object of class \code{network} from the package \code{network} or a \code{graph} object from the package \code{igraph}) from a FF, FO, or FM matrix
}
\details{
This function allows for a number of additional arguments.
}
\section{What can be passed to \code{vertex.colour} and \code{vertex.size}}{


The pieces of information that is possible to pass to \code{vertex.size} and \code{vertex.colour} are:
\itemize{
 \item \code{capitalisation}, will be arranged into steps (see \code{capitalisation.bins} below)
 \item \code{revenue}, will be arranged into steps (see \code{revenues.bins} below)
 \item \code{legal_form}
 \item \code{sector}
 \item \code{currency}
}
}

\section{What can be passed to \code{edge.width} and \code{edge.greyscale}}{


The pieces of information that is possible to pass to \code{edge.width} and \code{edge.greyscale} are:
- \code{capitalisation}
- \code{revenue}
}

\section{Additional parameters related to \code{vertex.size}}{


The effect of the additional parameters that modify the behaviour of \code{vertex.size} are:

\code{vertex.size.max} (defaults to \code{5}) :
 \itemize{
  \item if \code{vertex.size} or one of its aliases is specified, this is the size of the biggest vertex;
  \item if neither \code{vertex.size} nor any of its aliases is given, this is the size of ALL vertices.
 }

\code{vertex.size.min} (defaults to \code{1}):
 \itemize{
  \item if \code{vertex.size} or one of its aliases is specified, this is the size of the smallest vertex;
  \item if neither \code{vertex.size} nor any of its aliases is given, it is ignored.
 }
}

\section{Additional parameters related to \code{vertex.colour}}{


The only additional parameter related to \code{vertex.colour} is \code{vertex.colour.palette}.
It supports a vector of RGB or named colours (see \code{\link[grDevices]{colours}} for all named colours in \code{R}).
It also accepts complete calls to functions that return a such a vector like \code{RColorBrewer::brewer.pal(n, name)} or \code{viridisLite::viridis(n, option)}.
If the palette is too short, it will be extended automatically using \code{\link[grDevices]{colorRampPalette}}.
If the palette is not declared, but this arguemnt is \code{TRUE}, it will defaulr to the following vector of colours:
\itemize{
   \item \code{#00204D}, \href{https://www.color-name.com/hex/00204d}{Oxford Blue}
   \item \code{#31446B}, \href{https://www.color-name.com/hex/31446B}{Police Blue}
   \item \code{#666970}, \href{https://www.color-name.com/hex/666970}{Dim Gray}
   \item \code{#958F78}, \href{https://www.color-name.com/hex/958F78}{Artichoke}
   \item \code{#CBBA69}, \href{https://www.color-name.com/hex/CBBA69}{Dark Khaki}
   \item \code{#FFEA46}, \href{https://www.color-name.com/hex/FFEA46}{Gargoyle Gas}
}
If the argument is \code{FALSE}, \code{NULL} or \code{NA}, the vertex will be coloured of \code{#081677} (\href{https://www.color-name.com/gentian-blue.color}{Gentian blue}).
}

\section{Additional parameters related to \code{edge.width}}{


\code{edge.width.max} (defaults to \code{5}) :
 \itemize{
  \item if \code{edge.width} or one of its aliases is specified, this is the thickness of the thickest edge;
  \item if neither \code{edge.width} nor any of its aliases is given, this is the thickness of ALL edges
 }

\code{edge.width.min} (defaults to \code{1}):
 \itemize{
  \item if \code{edge.width} or one of its aliases is specified, this is the thickness of the slimmest edge;
  \item if neither \code{edge.width} nor any of its aliases is given, it is ignored.
 }
}

\section{Additional parameters related to \code{edge.greyscale}}{


\code{edge.greyscale.darkest} (defaults to \code{5}):
 \itemize{
  \item if \code{edge.greyscale} or one of its aliases is specified, this is the thickness of the thickest edge;
  \item if neither \code{edge.greyscale} nor any of its aliases is given, this is the thickness of ALL edges
 }

\code{edge.greyscale.fairest} (defaults to \code{1}):
 \itemize{
  \item if \code{edge.greyscale} or one of its aliases is specified, this is the thickness of the slimmest edge;
  \item if neither \code{edge.greyscale} nor any of its aliases is given, it is ignored.
 }

Several aliases are accepted for all arguments, except \code{M}:
\itemize{
 \item for \code{vertex.size}: \code{node.size}
 \item for \code{vertex.colour}: \code{vertex.color}, \code{node.colour}, and \code{node.color};
 \item for \code{edge.width}: \code{tie.width}
 \item for \code{edge.greyscale}: \code{tie.grayscale}, \code{tie.greyscale}, and \code{edge.grayscale}
}
}

\seealso{
\link{FF.net} \link{FF.net.custom} \link{FF.graph} \link{FF.graph.custom}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
\keyword{internal}
