% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/e_conversion.R
\name{roundcoefk}
\alias{roundcoefk}
\title{Round Coefk}
\usage{
roundcoefk(coefk, dgts = NULL, parnames = TRUE)
}
\arguments{
\item{coefk}{numeric, matrix or data.frame representing
parameters \code{c(m,g,a,k,w,d,e)}.}

\item{dgts}{integer. The number of rounded digits.}

\item{parnames}{boolean. Output displayed with or without parameter names.}
}
\description{
Round coefk parameters in a standard manner or in a special manner,
the latest being useful to display nice matrix or data.frame.
}
\details{
For \code{dgts} between 1 and 9, rounding is done in the standard way
and all parameters are rounded at the same number of digits.

For \code{dgts} between 10 and 27, rounding of parameters
\code{c(m,g,a,k,w,d,e)} is done in the following way:
\itemize{
  \item{ dgts = 10 : c(0, 0, 1, 1, 1, 3, 2)}
  \item{ dgts = 11 : c(1, 1, 1, 1, 1, 3, 2)}
  \item{ dgts = 12 : c(2, 2, 1, 1, 1, 3, 2)}
  \item{ dgts = 13 : c(3, 3, 1, 1, 1, 3, 2)}
  \item{ dgts = 14 : c(4, 4, 1, 1, 1, 3, 2)}
  \item{ dgts = 15 : c(5, 5, 1, 1, 1, 3, 2)}
  \item{ dgts = 16 : c(0, 0, 2, 2, 2, 3, 2)}
  \item{ dgts = 17 : c(1, 1, 2, 2, 2, 3, 2)}
  \item{ dgts = 18 : c(2, 2, 2, 2, 2, 3, 2)}
  \item{ dgts = 19 : c(3, 3, 2, 2, 2, 3, 2)}
  \item{ dgts = 20 : c(4, 4, 2, 2, 2, 3, 2)}
  \item{ dgts = 21 : c(5, 5, 2, 2, 2, 3, 2)}
  \item{ dgts = 22 : c(0, 0, 3, 3, 3, 4, 3)}
  \item{ dgts = 23 : c(1, 1, 3, 3, 3, 4, 3)}
  \item{ dgts = 24 : c(2, 2, 3, 3, 3, 4, 3)}
  \item{ dgts = 25 : c(3, 3, 3, 3, 3, 4, 3)}
  \item{ dgts = 26 : c(4, 4, 3, 3, 3, 4, 3)}
  \item{ dgts = 27 : c(5, 5, 3, 3, 3, 4, 3)}
}
}
\examples{
mat   <- matrix(runif(35), ncol=7)
coefk <- mat[1,]

roundcoefk(coefk, dgts = 2, parnames = FALSE)
roundcoefk(coefk, dgts = 15)
roundcoefk(mat, dgts = 15)
}

