% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmTestBoot}
\alias{rmTestBoot}
\title{Robust multiple testing with multiplier bootstrap}
\usage{
rmTestBoot(X, h0, alpha = 0.05, alternative = "two.sided", B = 500L)
}
\arguments{
\item{X}{An \eqn{n} by \eqn{p} data matrix with each row being a sample.}

\item{h0}{A \eqn{p}-vector of true means.}

\item{alpha}{An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.}

\item{alternative}{An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".}

\item{B}{An \strong{optional} positive integer specifying the size of bootstrap sample. The dafault value is 500.}
}
\description{
Internal function implemented in C++ for robust multiple testing without factor-adjustment, where p-values are obtained via multiplier bootstrap. 
This case is incorporated into \code{farm.test}.
}
\seealso{
\code{\link{farm.test}}
}
