% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_funcs.R
\name{farm.cov}
\alias{farm.cov}
\title{Covariance estimation with Huber's loss function}
\usage{
farm.cov(X)
}
\arguments{
\item{X}{an n x p data matrix with each row being a sample.}
}
\value{
A list with the following items
\item{covhat}{the covariance matrix}
}
\description{
This function estimates covariance of multivariate data using the Huber's loss. The tuning parameter is chosen by cross validation.
}
\examples{
set.seed(100)
p = 20
n = 10
X = matrix(rnorm( p*n, 0,1), nrow = n)
covhat = farm.cov(X)

}
\references{
Huber, P.J. (1964). "Robust Estimation of a Location Parameter." The Annals of Mathematical Statistics, 35, 73–101.
}
