% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDsib.R
\name{IDsib}
\alias{IDsib}
\title{IDs of siblings of ego}
\usage{
IDsib(idego, d = NULL)
}
\arguments{
\item{idego}{ID of ego}

\item{d}{Name of database. If d is missing, the dataset dLH in the global environment (R workspace) is used. 
If no dLH in the global environment, the database dLH distributed with the Families package is used.}
}
\value{
A list vector of two elements. 
\itemize{
 \item dfsib: dataframe of IDs of ego-sibling dyads. 
 \item id: vector of IDs of siblings. 
}

Returns NA if ID of sibling cannot be computed because the ID of mother is not included in the database.
}
\description{
Retrieves IDs of siblings of ego
}
\examples{
# Load data
data(dLH,package="Families")
# IDs of siblings of single member of generation 3
set.seed(34)
idego <- sample(dLH$ID[dLH$gen==3],1)
idsib <- IDsib (idego)

# For each member of generation 2, IDs of siblings
idego <- dLH$ID[dLH$gen==2]
idsib <- IDsib(idego)

}
