% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FB.R
\name{compute.fb}
\alias{compute.fb}
\title{Fractional Bias (FB)}
\usage{
compute.fb(Y, X, verbose = F)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}

\item{verbose}{if TRUE, print advice about the quality of the model}
}
\description{
Calculate the FB between two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the FB value of two vectors univariate signals. This indicator indicates whether predicted values are underestimated or overestimated compared to true values.
A perfect imputation model has \eqn{FB = 0}.
An imputation model is acceptable when its FB value is less than or equal to 0.3 (\eqn{FB <= 0.3}).
The two vectors Y and X are the same length, on the contrary an error will be displayed.
In both input vectors, eventual NA will be exluded with a warning diplayed.
}
\examples{
data(dataFSMUMI)
X <- dataFSMUMI[, 1] ; Y <- dataFSMUMI[, 2]
compute.fb(Y,X)
compute.fb(Y,X, verbose = TRUE)

# If mean(X)=mean(Y)=0, it is impossible to estimate FB,
# unless both true and imputed values vectors are constant.
# By definition, in this case, FB = 0.
X <- rep(0, 10) ; Y <- rep(0, 10)
compute.fb(Y,X)

# If true and imputed values are not zero and are opposed, FB = Inf.
X <- rep(runif(1), 10)
Y <- -X
compute.fb(Y,X)
}
\author{
Thi-Thu-Hong Phan, Andre Bigand, Emilie Poisson-Caillault
}
