% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/YPerchSB.R
\docType{data}
\name{YPerchSB}
\alias{YPerchSB}
\title{Stock and recruitment data for Yellow Perch from South Bay, Lake Huron, 1950-1983.}
\format{A data frame with 15 observations on the following 3 variables:
 \describe{
   \item{year}{Year of data}
   \item{stock}{Spawning stock (number per set)}
   \item{recruits}{Recruits (number per set)}
 }}
\source{
From Henderson, B.A. 1985. Factors affecting growth and recruitment of yellow perch, \emph{Perca flavescens} Mitchill, in South Bay, Lake Huron. Journal of Fisheries Biology 26:449-458. Obtained from Ransom Myers online database which was (is?) at http://ram.biology.dal.ca/~myers/data.html.
}
\description{
Yellow Perch (\emph{Perca flavescens}) stock and recruitment by year in South Bay, Lake Huron, 1950-1983.
}
\section{Topic(s)}{

 \itemize{
   \item Stock-Recruit
   \item Recruitment
 }
}

\examples{
data(YPerchSB)
str(YPerchSB)
head(YPerchSB)
op <- par(mfrow=c(1,2),pch=19)
plot(recruits~year,data=YPerchSB,type="b")
plot(recruits~stock,data=YPerchSB)
par(op)

}
\concept{Recruitment}
\concept{Stock-Recruit}
\keyword{datasets}
