#' @title Catch and effort data for Northern Pike from Island Lake, NB.
#' 
#' @description Catch and effort data for nine removal events of Northern Pike (\emph{Esox lucius}) from Island Lake, NB.
#' 
#' @name PikeIL
#' 
#' @docType data
#' 
#' @format A data frame with 9 observations on the following 3 variables:
#'  \describe{
#'    \item{date}{Capture date.} 
#'    \item{nets}{Number of fyke nets fished on that date.} 
#'    \item{catch}{Number of captured and removed pike.} 
#'  }
#'  
#' @section Topic(s):
#'  \itemize{
#'    \item Depletion methods 
#'    \item Leslie method
#'    \item DeLury method 
#'    \item Population size 
#'    \item Abundance 
#'    \item Catchability
#'  }
#'  
#' @concept Abundance
#' @concept Population Size
#' @concept Leslie
#' @concept DeLury
#' @concept Depletion
#' @concept Catchability
#' 
#' @source From Table 1 of Peterson, J., M. Taylor, and A. Hanson. 1980. Leslie population estimate for a large lake. Transactions of the American Fisheries Society, 109:329-331.
#' 
#' @keywords datasets
#' 
#' @examples
#' data(PikeIL)
#' str(PikeIL)
#' head(PikeIL)
#' 
NULL