#' @title Capture histories (2 sample) of Rainbow Trout.
#' 
#' @description Capture histories for Rainbow Trout (\emph{Oncorhynchus mykiss}) in Upper Niagara Springs pond.
#' 
#' @name RBTroutUNSP
#' 
#' @docType data
#' 
#' @format A data frame with 173 observations on the following 2 variables:
#'  \describe{
#'    \item{first}{Indicator variable for the first sample (1=captured).} 
#'    \item{second}{Indicator variable for the second sample (1=captured).} 
#'  }
#'  
#' @section Topic(s):
#'  \itemize{
#'    \item Population size 
#'    \item Abundance 
#'    \item Mark-recapture 
#'    \item Petersen method 
#'    \item Capture history 
#'  }
#'  
#' @concept Abundance 'Population Size' 'Mark-Recapture' 'Petersen' 'Capture History'
#' 
#' @source Simulated from Table 10 in of Warren, C.D., K.A. Frank, and F.E. Partridge.  2004.  Federal aid in fish restoration - 2000 job performance report. Idaho Department of Fish and Game.
#' 
#' @keywords datasets
#' 
#' @examples
#' data(RBTroutUNSP)
#' str(RBTroutUNSP)
#' head(RBTroutUNSP)
#' 
NULL