% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{capFirst}
\alias{capFirst}
\title{Capitalizes the first letter of first or all words in a string.}
\usage{
capFirst(x, which = c("all", "first"))
}
\arguments{
\item{x}{A single string.}

\item{which}{A single string that indicates whether all (the default) or only the first words should be capitalized.}
}
\value{
A single string with the first letter of the first or all words capitalized.
}
\description{
Capitalizes the first letter of first or all words in a string.
}
\examples{
## Capitalize first letter of all words (the default)
capFirst("Derek Ogle")
capFirst("derek ogle")
capFirst("derek")

## Capitalize first letter of only the first words
capFirst("Derek Ogle",which="first")
capFirst("derek ogle",which="first")
capFirst("derek",which="first")
## apply to all elements in a vector
vec <- c("Derek Ogle","derek ogle","Derek ogle","derek Ogle","DEREK OGLE")
capFirst(vec)
capFirst(vec,which="first")

## check class types
class(vec)
vec1 <- capFirst(vec)
class(vec1)
fvec <- factor(vec)
fvec1 <- capFirst(fvec)
class(fvec1)

}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\keyword{manip}
