context("removal() OUTPUT")

test_that("removal() return types",{
  expect_equal(class(removal(c(38,26,12))),"removal")
  expect_equal(class(removal(c(38,26,12),method="Moran")),"removal")
  expect_equal(class(removal(c(38,26,12),method="Zippin")),"removal")
  expect_equal(class(removal(c(38,26,12),method="Schnute")),"removal")
  expect_equal(class(removal(c(38,26,12),method="Seber3")),"removal")
  expect_equal(class(removal(c(38,26),method="Seber2")),"removal")
  expect_equal(class(removal(c(38,26),method="RobsonRegier2")),"removal")
  expect_equal(class(removal(c(38,26,12),method="Burnham")),"removal")
  # do one-dimensional data.frames and matrices work?
  expect_equal(class(removal(data.frame(c(38,26,12)))),"removal")
  expect_equal(class(removal(matrix(c(38,26,12),nrow=1))),"removal")
  expect_equal(class(removal(matrix(c(38,26,12),ncol=1))),"removal")

  # summary() results
  tmp <- removal(c(38,26,12))
  tmp2 <- summary(tmp)
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),2)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("No","p"))
  expect_equal(colnames(tmp2),c("Estimate","Std. Error"))
  tmp2 <- summary(tmp,parm="p")
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),1)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("p"))
  expect_equal(colnames(tmp2),c("Estimate","Std. Error"))
  tmp2 <- summary(tmp,parm="No")
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),1)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("No"))
  expect_equal(colnames(tmp2),c("Estimate","Std. Error"))
  tmp <- removal(c(38,26,12),method="Schnute")
  tmp2 <- summary(tmp)
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),3)
  expect_equal(ncol(tmp2),1)
  expect_equal(rownames(tmp2),c("No","p","p1"))
  expect_equal(colnames(tmp2),c("Estimate"))
  tmp2 <- summary(tmp,parm="p1")
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),1)
  expect_equal(ncol(tmp2),1)
  expect_equal(rownames(tmp2),c("p1"))
  expect_equal(colnames(tmp2),c("Estimate"))
  tmp2 <- summary(tmp,parm=c("p","No"))
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),2)
  expect_equal(ncol(tmp2),1)
  expect_equal(rownames(tmp2),c("No","p"))
  expect_equal(colnames(tmp2),c("Estimate"))
  tmp <- removal(c(38,26),method="Seber2")
  tmp2 <- summary(tmp)
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),2)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("No","p"))
  expect_equal(colnames(tmp2),c("Estimate","Std. Error"))

  # confint() results
  tmp <- removal(c(38,26,12))
  tmp2 <- confint(tmp)
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),2)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("No","p"))
  expect_equal(colnames(tmp2),c("95% LCI","95% UCI"))
  tmp2 <- confint(tmp,parm="p")
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),1)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("p"))
  expect_equal(colnames(tmp2),c("95% LCI","95% UCI"))
  tmp2 <- confint(tmp,parm="No")
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),1)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("No"))
  expect_equal(colnames(tmp2),c("95% LCI","95% UCI"))
  tmp <- removal(c(38,26,12),method="Schnute")
  tmp2 <- confint(tmp)
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),1)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("No"))
  expect_equal(colnames(tmp2),c("95% LCI","95% UCI"))
  tmp2 <- confint(tmp,parm="No")
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),1)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("No"))
  expect_equal(colnames(tmp2),c("95% LCI","95% UCI"))
  tmp <- removal(c(38,26),method="Seber2")
  tmp2 <- confint(tmp)
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),2)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("No","p"))
  expect_equal(colnames(tmp2),c("95% LCI","95% UCI"))
  tmp2 <- confint(tmp,parm="p")
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),1)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("p"))
  expect_equal(colnames(tmp2),c("95% LCI","95% UCI"))
  tmp2 <- confint(tmp,parm="No")
  expect_is(tmp2,"matrix")
  expect_equal(nrow(tmp2),1)
  expect_equal(ncol(tmp2),2)
  expect_equal(rownames(tmp2),c("No"))
  expect_equal(colnames(tmp2),c("95% LCI","95% UCI"))

  ## What if catches are all zeroes
  suppressWarnings(expect_true(all(is.na(removal(c(0,0,0),method="Zippin")$est))))
  suppressWarnings(expect_true(all(is.na(removal(c(0,0,0),method="Schnute")$est))))
  suppressWarnings(expect_true(all(is.na(removal(c(0,0,0),method="Moran")$est))))
  suppressWarnings(expect_true(all(is.na(removal(c(0,0,0),method="Seber3")$est))))
  suppressWarnings(expect_true(all(is.na(removal(c(0,0),method="Seber2")$est))))
  suppressWarnings(expect_true(all(is.na(removal(c(0,0),method="RobsonRegier2")$est))))
  suppressWarnings(expect_true(all(is.na(removal(c(0,0,0),method="Burnham")$est))))
})
