% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{Basis_obj-class}
\alias{Basis_obj-class}
\alias{Basis-class}
\alias{TensorP_Basis-class}
\title{Basis functions}
\description{
An object of class \code{Basis} contains the basis functions used to construct the matrix \eqn{S} in FRK. It contains five slots, described below.
}
\details{
Basis functions are a central component of \code{FRK}, and the package is designed to work with user-defined specifications of these. For convenience, however, several functions are available to aid the user to construct a basis set for a given set of data points. Please see \code{\link{auto_basis}} for more details. The function \code{\link{local_basis}} helps the user construct a set of local basis functions (e.g., bisquare functions) from a collection of location and scale parameters.
}
\section{Slots}{

\describe{
\item{\code{manifold}}{an object of class \code{manifold} that contains information on the manifold and the distance measure used on the manifold. See \code{\link{manifold-class}} for more details}

\item{\code{n}}{the number of basis functions in this set}

\item{\code{fn}}{a list of length \code{n}, with each item the function of a specific basis function}

\item{\code{pars}}{a list of parameters where the \eqn{i}-th item in the list contains the parameters of the \eqn{i}-th basis function, \code{fn[[i]]}}

\item{\code{df}}{a data frame containing other attributes specific to each basis function (for example the geometric centre of the local basis function)}
}}

\keyword{Basis}
\keyword{functions}
