% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_olfreg.R
\name{plot_olfreg}
\alias{plot_olfreg}
\title{Plot coefficients from OLFREG model}
\usage{
plot_olfreg(object)
}
\arguments{
\item{object}{OLFREG model}
}
\value{
plot of the beta coefficient regression functions for each intercept and for each variable
}
\description{
Plot coefficients from OLFREG model
}
\examples{
\donttest{
# cycling dataset
library(fda)
# creation of ordinal variable from HR variable
zoneHR=rep(0,216)
zoneHR[which(rowMeans(cycling$HR[,1:1700])<107)]=1
zoneHR[which((rowMeans(cycling$HR[,1:1700])<125)&(rowMeans(cycling$HR[,1:1700])>107))]=2
zoneHR[which((rowMeans(cycling$HR[,1:1700])<142)&(rowMeans(cycling$HR[,1:1700])>125))]=3
zoneHR[which((rowMeans(cycling$HR[,1:1700])<160)&(rowMeans(cycling$HR[,1:1700])>142))]=4
zoneHR[which((rowMeans(cycling$HR[,1:1700])>160))]=5
# first functional variable - power (WATTS)
watts = t(cycling$WATTS[,1:1700])
# set up a fourier basis system due to its cycling pattern
xbasis = create.fourier.basis(c(1,1700),50) # 50 basis functions for example
watts.fd = smooth.basis(c(1:1700),watts,xbasis)$fd
zoneHR = as.factor(zoneHR)
# additional functional variable - cadence (CAD)
cad = t(cycling$CAD[,1:1700])
# set up a functional variable for cad
xbasis2 = create.bspline.basis(c(1,1700), nbasis = 25, norder = 4)
cad.fd = smooth.basis(c(1:1700),cad,xbasis2)$fd
formula = zoneHR ~ watts.fd + cad.fd
olfreg.model = olfreg(formula = formula)
plot_olfreg(olfreg.model)
}
}
