% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{BERT_vocab}
\alias{BERT_vocab}
\title{Check if mask words are in the model vocabulary.}
\usage{
BERT_vocab(models, mask.words)
}
\arguments{
\item{models}{Model names at
\href{https://huggingface.co/models?pipeline_tag=fill-mask&library=transformers}{HuggingFace}.}

\item{mask.words}{Option words filling in the mask.}
}
\value{
A data.table of model names, mask words, and real tokens (replaced if out of vocabulary).
}
\description{
Check if mask words are in the model vocabulary.
}
\examples{
\dontrun{
models = c("bert-base-uncased", "bert-base-cased")
BERT_vocab(models, c("bruce", "Bruce"))
BERT_vocab(models, 1800:2024)
}

}
\seealso{
\code{\link{BERT_download}}
}
