% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFTreesdata_doc.R
\docType{data}
\name{forestfires}
\alias{forestfires}
\title{Forest fires data}
\format{
A data frame containing 517 rows and 13 columns.

\describe{
  \item{X}{Integer -x-axis spatial coordinate within the Montesinho park map: 1 to 9}
  \item{Y}{Integer - y-axis spatial coordinate within the Montesinho park map: 2 to 9}
  \item{month}{Factor - month of the year: "jan" to "dec" }
  \item{day}{Factor -day of the week: "mon" to "sun"}
  \item{FFMC}{Numeric -FFMC index from the FWI system: 18.7 to 96.20}
  \item{DMC}{Numeric - DMC index from the FWI system: 1.1 to 291.3 }
  \item{DC}{Numeric - DC index from the FWI system: 7.9 to 860.6 }
  \item{ISI}{Numeric - ISI index from the FWI system: 0.0 to 56.10}
  \item{temp}{Numeric - temperature in Celsius degrees: 2.2 to 33.30}
  \item{RH}{Numeric - relative humidity in percent: 15.0 to 100 }
  \item{wind}{Numeric - wind speed in km/h: 0.40 to 9.40 }
  \item{rain}{Numeric - outside rain in mm/m2 : 0.0 to 6.4 }
  \item{fire.crit}{\emph{Criterion}: Was there a fire (greater than 1.00 ha)?

  Values: \code{TRUE} (yes) vs. \code{FALSE} (no) (47.0\% vs. 53.0\%).}

}
}
\source{
\url{http://archive.ics.uci.edu/ml/datasets/Forest+Fires}

Original creator:
Prof. Paulo Cortez and Aníbal Morais
Department of Information Systems
University of Minho, Portugal
}
\usage{
forestfires
}
\description{
A dataset of forest fire statistics.
}
\details{
We made the following enhancements to the original data for improved usability:

\itemize{
 \item{The criterion was redefined from a numeric variable that indicated the number of hectares that burned in a fire into a logical variable (\code{TRUE} (for values >1) vs. \code{FALSE} (for values <=1)).}
 }

 Other than that, the data remains consistent with the original dataset.
}
\seealso{
Other datasets: 
\code{\link{blood}},
\code{\link{breastcancer}},
\code{\link{car}},
\code{\link{contraceptive}},
\code{\link{creditapproval}},
\code{\link{fertility}},
\code{\link{heart.cost}},
\code{\link{heart.test}},
\code{\link{heart.train}},
\code{\link{heartdisease}},
\code{\link{iris.v}},
\code{\link{mushrooms}},
\code{\link{sonar}},
\code{\link{titanic}},
\code{\link{voting}},
\code{\link{wine}}
}
\concept{datasets}
\keyword{datasets}
