% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{funplot}
\alias{funplot}
\title{Plot functional data with linear interpolation of missing values}
\usage{
funplot(x, y, id = NULL, rug = TRUE, ...)
}
\arguments{
\item{x}{optional, time-vector for plotting}

\item{y}{matrix of functional data with functions in rows and measured times in columns; 
or vector or functional observations, in this case id has to be specified}

\item{id}{defaults to NULL for y matrix, is id-variables for y in long format}

\item{rug}{logical. Should rugs be plotted? Defaults to TRUE.}

\item{...}{further arguments passed to \code{\link[graphics]{matplot}}.}
}
\description{
Plot functional data with linear interpolation of missing values
}
\details{
All observations are marked by a small cross (\code{pch=3}).
Missing values are imputed by linear interpolation. Parts that are
interpolated are plotted by dotted lines, parts with non-missing values as solid lines.
}
\examples{
\dontrun{
### examples for regular data in wide format
data(viscosity)
with(viscosity, funplot(timeAll, visAll, pch=20))
if(require(fda)){
  with(fda::growth, funplot(age, t(hgtm)))
}
}
}
