% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FDboostLSS.R
\name{cvrisk.FDboostLSS}
\alias{cvrisk.FDboostLSS}
\title{Cross-validation for FDboostLSS}
\usage{
\method{cvrisk}{FDboostLSS}(object, folds = cvLong(id = object[[1]]$id,
  weights = model.weights(object[[1]])), grid = make.grid(mstop(object)),
  papply = mclapply, trace = TRUE, fun = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{FDboostLSS}.}

\item{folds}{a weight matrix a weight matrix with number of rows equal to the number of observations.
The number of columns corresponds to the number of cross-validation runs,
defaults to 25 bootstrap samples, resampling whole curves}

\item{grid}{a matrix of stopping parameters the empirical risk is to be evaluated for.
Each row represents a parameter combination. The number of columns must be equal to the number
of parameters of the GAMLSS family. Per default, make.grid(mstop(object)) is used.}

\item{papply}{(parallel) apply function, defaults to \code{\link[parallel]{mclapply}},
see \code{\link[gamboostLSS]{cvrisk.mboostLSS}} for details}

\item{trace}{print status information during cross-validation? Defaults to \code{TRUE}.}

\item{fun}{if \code{fun} is \code{NULL}, the out-of-sample risk is returned.
\code{fun}, as a function of \code{object},
may extract any other characteristic of the cross-validated models. These are returned as is.}

\item{...}{additional arguments passed to \code{\link[parallel]{mclapply}}.}
}
\value{
An object of class \code{cvriskLSS} (when \code{fun} was not specified),
basically a matrix containing estimates of the empirical risk for a varying number
of bootstrap iterations. \code{plot} and \code{print} methods are available as well as an
\code{mstop} method, see \code{\link[gamboostLSS]{cvrisk.mboostLSS}}.
}
\description{
Multidimensional cross-validated estimation of the empirical risk for hyper-parameter selection,
for an object of class \code{FDboostLSS} setting the folds per default to resampling curves.
}
\details{
The function \code{cvrisk.FDboostLSS} is a wrapper for
\code{\link[gamboostLSS]{cvrisk.mboostLSS}} in package gamboostLSS.
It overrieds the default for the folds, so that the folds are sampled on the level of curves
(not on the level of single observations, which does not make sense for functional response).
}
\seealso{
\code{\link[gamboostLSS]{cvrisk.mboostLSS}} in packge gamboostLSS.
}

