% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_aux.R
\name{FracDiff}
\alias{FracDiff}
\title{Fast Fractional Differencing}
\usage{
FracDiff(x, d)
}
\arguments{
\item{x}{A matrix of variables to be included in the system.}

\item{d}{The order of fractional differencing.}
}
\value{
A vector or matrix \code{dx} equal to \eqn{(1-L)^d x}
of the same dimensions as x.
}
\description{
\code{FracDiff} is a fractional differencing procedure based on the
	fast fractional difference algorithm of Jensen & Nielsen (2014).
}
\note{
This function differs from the \code{diffseries} function
in the \code{fracdiff} package, in that the \code{diffseries}
function demeans the series first.
In particular, the difference between the out put of the function calls
\code{FCVAR::FracDiff(x - mean(x), d = 0.5)}
and \code{fracdiff::diffseries(x, d = 0.5)} is numerically small.
}
\examples{
set.seed(42)
WN <- matrix(stats::rnorm(200), nrow = 100, ncol = 2)
\donttest{MVWNtest_stats <- MVWNtest(x = WN, maxlag = 10, printResults = 1)}
x <- FracDiff(x = WN, d = - 0.5)
\donttest{MVWNtest_stats <- MVWNtest(x = x, maxlag = 10, printResults = 1)}
WN_x_d <- FracDiff(x, d = 0.5)
\donttest{MVWNtest_stats <- MVWNtest(x = WN_x_d, maxlag = 10, printResults = 1)}
}
\references{
Jensen, A. N. and M. \enc{Ø}{O}. Nielsen (2014).
"A fast fractional difference algorithm,"
Journal of Time Series Analysis 35, 428-436.
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} calls \code{GetParams}, which calls \code{TransformData}
to estimate the FCVAR model.
\code{TransformData} in turn calls \code{FracDiff} and \code{Lbk}
to perform the transformation.

Other FCVAR auxiliary functions: 
\code{\link{FCVARforecast}()},
\code{\link{FCVARlikeGrid}()},
\code{\link{FCVARsimBS}()},
\code{\link{FCVARsim}()},
\code{\link{plot.FCVAR_grid}()}
}
\concept{FCVAR auxiliary functions}
