% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.vector.R
\name{norm.vector}
\alias{norm.vector}
\title{Min-Max Feature scaling normalization}
\usage{
norm.vector(x, a.b = NULL)
}
\arguments{
\item{x}{A vector}

\item{a.b}{A vector that indicates the minimum and maximum scaling values}
}
\value{
A normalized vector
}
\description{
Normalizes a vector using the Min-Max Feature scaling method (a.k.a unity-based normalization)
}
\details{
Feature scaling is used to bring all values into the range [0,1]. This is also called unity-based normalization.
When 'a.b = NULL' (default), the highest and lowest values in 'x' will turn to 1 and 0, respectively, while all values in between will be re-scaled.
Defining 'a.b' will bring all values into the range [a,b].
}
\examples{
\donttest{
x <- seq(from = 1, to = 100, by = 0.1)
y <- sin(sqrt(x))
plot(y~x, type = "l")

y.n <- norm.vector(y)
plot(y.n~x, type = "l")

y.ab <- norm.vector(y, a.b = c(5,20))
plot(y.ab~x, type = "l")
}
}
\author{
Alejandro Linares
}
