% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindSpeed.R
\name{WndSp2m}
\alias{WndSp2m}
\title{Wind Speed at the height 2 m Above Ground Surface}
\usage{
WndSp2m(u_z, z, speed = NULL)
}
\arguments{
\item{u_z}{Optional. A numeric scalar that denotes the measured wind speed at z m above ground surface [m/s].}

\item{z}{A numeric scalar that denotes the height of measurement above ground surface [m].}

\item{speed}{Optional. A character string that denotes the wind speed general class and can be assigned
\code{"str"} for strong winds, \code{"mod2str"} for moderate to strong winds,
\code{"lig2mod"} for light to moderate winds, and \code{"lig"} for light winds.}
}
\value{
The function returns the value of the wind speed [m/s] as a numeric scalar.
}
\description{
\code{WndSp} returns the value of wind speed at the height 2 m above the ground surface.
}
\details{
This is a function to calculate the wind speed [m/s]. If \code{u_z} is missing, the function estimate the
   wind speed based on wind general or empirical classes.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
WndSp2m(u_z = 3.2, z = 10)
WndSp2m(speed = "mod2str")

}
