% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radiation.R
\name{ExRad}
\alias{ExRad}
\title{Extraterrestrial Radiation for Daily Periods (R_a)}
\usage{
ExRad(d_r, omega_s, phi, delta, G_sc = 0.082)
}
\arguments{
\item{d_r}{A numeric scalar that denotes the inverse relative earth-sun distance.}

\item{omega_s}{A numeric scalar that denotes the sunset hour angle [rad].}

\item{phi}{A numeric scalar that denotes the latitude [rad].}

\item{delta}{A numeric scalar that denotes the solar declination [rad].}

\item{G_sc}{A numeric scalar that denotes the solar constant = 0.0820 [\eqn{MJ/(m^2\times min)}].}
}
\value{
The function returns the value of extraterrestrial radiation as a numeric scalar.
}
\description{
\code{ExRad} returns the value of extraterrestrial radiation [\eqn{MJ/(m^2\times day)}].
}
\details{
This is a function to calculate the extraterrestrial radiation.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
ExRad(d_r = 0.985, omega_s = 1.527, phi = -0.35, delta = 0.12)

}
\seealso{
\code{\link{EarSunDis}, \link{SunHA}, \link{SolDec}, \link{SolRad}, \link{CSSRad}}.
}
