% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_par_function.R
\name{combine.par}
\alias{combine.par}
\title{Combine Fitted and Non-fitted Parameters}
\usage{
combine.par(fit.par, all.names, default.val = NULL)
}
\arguments{
\item{fit.par}{A named vector containing all parameters that are supposed to be fitted.}

\item{all.names}{A vector containing the names of all parameters (fitted and non-fitted).}

\item{default.val}{A named list containing the values that the non-fitted parameters should take. If NULL, all non-fitted parameters will be set to zero. Default values can be either given by a numeric value or by the name of the corresponding parameter the value should be inherited from (NOTE: If a string is supplied, the corresponding parameter entry has to contain a numeric value). Default to NULL.}
}
\value{
A named vector containing the elements of \code{fit.par} and the non-fitted parameters, in the order given by \code{all.names}. The non-fitted parameters are determined by the remaining names in \code{all.names} and their values are set according to \code{default.val}.
}
\description{
Combines fitted and non-fitted parameters into a single vector, taking into account the specified default values.
}
\examples{
#set parameters, names and default values
fits <- c(p1 = 3, p4 = -2)
par.names <- c("p1", "p2", "p3", "p4", "p5")
defaults <- list(p1 = 4, p2 = 10, p3 = "p1", p4 = 0, p5 = "p4")

#combine the parameters in different ways
combine.par(fit.par = fits, all.names = par.names)
combine.par(fit.par = fits, all.names = par.names, default.val = defaults)

}
