\name{hist.eba}
\alias{hist.eba}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Histograms for Extreme Bounds Analysis
%%  ~~function to do ... ~~
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
\code{hist.eba} is used to generate a set of histograms that present the results of extreme bounds analysis graphically. Each histogram illustrates the distribution of regression coefficients across the models estimated in the course of EBA. In addition, function \code{hist.eba} can overlay each histogram with lines that indicate the value of the regression coefficient assumed under the null hypothesis (argument \code{mu.show}), as well as with curves that indicate the distribution's kernel density (argument \code{density.show}) and a normally distributed approximation (argument \code{normal.show}). Additional formatting options are available. }
\usage{
\method{hist}{eba}(x, variables = NULL, col = "gray", freq = FALSE, main = NULL,
     mu.show = TRUE, mu.col = "red", mu.lwd = 2, mu.visible = TRUE,
     density.show = TRUE, density.col = "blue", density.lwd = 2, density.args = NULL, 
     normal.show = FALSE, normal.col = "darkgreen", normal.lwd = 2, 
     normal.weighted = FALSE, xlab = "regression coefficient", xlim = NULL, ...) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{an object of class \code{"eba"}, typically generated by the \code{\link{eba}} function.}
  \item{variables}{a character vector that specifies the variables for which histograms are requested. If NULL, histograms for all variables will be produced.}
  \item{col}{a color to be used to fill the histogram bars. Default is \code{"gray"}.}
  \item{freq}{logical; if TRUE, the histogram graphic is a representation of frequencies, the counts component of the result; if FALSE, probability densities, component density, are plotted (so that the histogram has a total area of one). Defaults to TRUE if and only if breaks are equidistant (and probability is not specified).}
  \item{main}{a named character vector that specifies the histogram title labels for the requested variables. The name of the vector component specifies the variable, while the content of the component itself contains the title label. If the vector's components are not named, variables are labelled in the order that they appear in the argument \code{variables}.}
  \item{mu.show}{logical; if TRUE (default), a vertical line for each variable's regression coefficient value assumed under the null hypothesis (specified by the \code{mu} argument of the \code{\link{eba}} function, with a default of 0) will be drawn over the histograms. }
  \item{mu.col}{a color to be used to draw the vertical line at \code{mu}. Default is \code{"red"}.}
  \item{mu.lwd}{the line width for vertical line at \code{mu}. Default is 2.}
  \item{mu.visible}{logical; if TRUE (default), make sure that the histograms' horizontal axes are scaled so that the vertical line at \code{mu} is always visible.}
  \item{density.show}{logical; if TRUE, a kernel density curve for the regression coefficients' distribution will be drawn over the histograms. The kernel densities are calculated using the standard \code{density} function. Additional arguments can be passed on to the \code{density} function via the \code{density.args} argument.}
  \item{density.col}{a color to be used to draw the kernel density curve. Default is \code{"blue"}.}
  \item{density.lwd}{the line width for the kernel density curve. Default is 2.}
  \item{density.args}{a list of additional arguments that will be passed on to the kernel \code{density} function.}
  \item{normal.show}{logical; if TRUE, a density curve for the normal distribution function will be drawn over the histograms. For each variable, the distribution's mean and standard error will be the means and standard errors of the corresponding regression coefficients.}
  \item{normal.col}{a color to be used to draw the normal distribution density curve. Default is \code{"darkgreen"}.}
  \item{normal.lwd}{the line width for the normal distribution density curve. For more detail, see the documentation for \code{lwd} in \code{\link{par}}. Default is 2.}
  \item{normal.weighted}{logical; If TRUE, the normal distribution density shown by \code{normal.show} will use the weighted mean and standard error, with each regression model's weight specified by \code{eba}'s argument \code{weights}. If FALSE (default), the unweighted mean and standard error will be used (i.e., each regression model receives equal weight).}
  \item{xlab}{a character string that specifies a label for the horizontal axis.}
  \item{xlim}{the range of x values with sensible defaults.}
  \item{\dots}{additional arguments that will be passed on to the \code{\link{hist}} function that creates the histograms.}
%%     ~~Describe \code{\dots} here~~
}
\value{
\code{hist.eba} returns an object of class \code{"hist.eba"}.

An object of class \code{"hist.eba"} is a list containing the following components:
  \item{call}{the matched call}
  \item{histograms}{a list of objects of class \code{histogram} that store information about the histograms produced by \code{hist.eba}. The histograms are included in the order that was requested and are indexed by the variable name. See the documentation for the default \code{\link{hist}} method for more information.}
}
\author{
%%  ~~who you are~~
Marek Hlavac   < hlavac at fas.harvard.edu > \cr
Harvard University, Political Economy and Government \cr
}
\section{Please cite as:}{
Hlavac, Marek (2014). ExtremeBounds: Extreme Bounds Analysis in R.\cr
R package version 0.1.2. http://CRAN.R-project.org/package=ExtremeBounds 
}
\seealso{
\code{\link{density}}, \code{\link{eba}}, \code{\link{hist}}, \code{\link{print.eba}}
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
# perform Extreme Bound Analysis
eba.results <- eba(data = mtcars[1:10, ], y = "mpg", free = "wt",
                   doubtful = c("cyl","disp","hp","drat","qsec","vs","am","gear","carb"),
                   focus = c("hp","gear"), k = 0:2)

# create histograms, keeping the default settings
hist(eba.results)

# re-create histograms with customized settings
hist(eba.results, variables = c("hp","gear"),
     main = c("hp" = "Gross horsepower", "gear" = "Number of forward gears"),
     mu.visible=FALSE, normal.show=TRUE, normal.lwd=1)
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
}
\keyword{ models }
\keyword{ regression }
\keyword{ nonlinear }
\keyword{ robust }
\keyword{ multivariate }

