% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Beta_ab.R
\name{Beta_ab}
\alias{Beta_ab}
\alias{dBeta_ab}
\alias{eBeta_ab}
\alias{lBeta_ab}
\alias{pBeta_ab}
\alias{qBeta_ab}
\alias{rBeta_ab}
\alias{sBeta_ab}
\title{The four-parameter beta distribution.}
\usage{
dBeta_ab(x, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), ...)

pBeta_ab(q, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1), ...)

qBeta_ab(p, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1), ...)

rBeta_ab(n, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), ...)

eBeta_ab(X, w, method = "numerical.MLE", ...)

lBeta_ab(X, w, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), logL = TRUE, ...)

sBeta_ab(X, w, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), ...)
}
\arguments{
\item{x,q}{A vector of quantiles.}

\item{shape1,shape2}{Shape parameters.}

\item{a,b}{Boundary parameters.}

\item{params}{A list that includes all named parameters.}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical; if TRUE, lBeta_ab gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dBeta_ab gives the density, pBeta_ab the distribution function,
qBeta_ab the quantile function, rBeta_ab generates random deviates, and
eBeta_ab estimates the parameters. lBeta_ab provides the log-likelihood function, sBeta_ab the observed score function
and iBeta_ab the observed information matrix.
}
\description{
Density, distribution, quantile, random number
generation, and parameter estimation functions for the 4-parameter beta distribution.
Parameter estimation can be based on a weighted or unweighted i.i.d sample and can be performed
numerically.
}
\details{
The \code{dBeta_ab()}, \code{pBeta_ab()}, \code{qBeta_ab()},and \code{rBeta_ab()} functions serve as wrappers of the standard
\code{\link[stats]{dbeta}}, \code{\link[stats]{pbeta}}, \code{\link[stats]{qbeta}} and \code{\link[stats]{rbeta}} functions
in the \pkg{\link{stats}} package.They allow for the parameters to be declared not only as
individual numerical values, but also as a list so parameter estimation can be carried out. \cr
\cr
The four-parameter beta distribution with parameters \code{shape1}=p, \code{shape2}=q, \code{a} = \eqn{a} and \code{b}=\eqn{b}
has probability density function
\deqn{f(x) = \frac{1}{B(p,q)} \frac{(x-a)^{(p-1)})(b-x)^{(q-1)}}{((b-a)^{(p+q-1)}))}}
with \eqn{p >0}, \eqn{q > 0}, \eqn{a \leq x \leq b} and where B is the \link[base]{beta} function, Johnson et.al (p.210). \cr
\cr
The log-likelihood function of the four-parameter beta distribution is
\deqn{l(p,q,a,b| x) = -ln B(p,q) + ((p-1) ln (x-a) + (q-1) ln (b-x)) - (p + q -1) ln (b-a).}
Johnson et.al (p.226) provides the Fisher's information matrix of the four-parameter beta distribution in
the regular case where \eqn{p,q > 2}.
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rBeta_ab(n=500, shape1=2, shape2=5, a=1, b=2)
est.par <- eBeta_ab(X); est.par
plot(est.par)

# Fitted density curve and histogram
den.x <- seq(min(X),max(X),length=100)
den.y <- dBeta_ab(den.x,params = est.par)
hist(X, breaks=10, probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue")   # Original data
lines(density(X), lty=2)          # Fitted density curve

# Extracting boundary and shape parameters
est.par[attributes(est.par)$par.type=="boundary"]
est.par[attributes(est.par)$par.type=="shape"]

# Parameter Estimation for a distribution with unknown shape parameters
# Example from: Bury(1999) pp.261-262, parameter estimates as given by Bury are
# shape1 = 4.088, shape2 = 10.417, a = 1.279 and b = 2.407.
# The log-likelihood for this data and Bury's parameter estimates is 8.598672.
data <- c(1.73, 1.5, 1.56, 1.89, 1.54, 1.68, 1.39, 1.64, 1.49, 1.43, 1.68, 1.61, 1.62)
est.par <- eBeta_ab(X=data, method="numerical.MLE");est.par
plot(est.par)

# Estimates calculated by eBeta_ab differ from those given by Bury(1999).
# However, eBeta_ab's parameter estimates appear to be an improvement, due to a larger
# log-likelihood of 9.295922 (as given by lBeta_ab below).

# log-likelihood and score functions
lBeta_ab(data,param = est.par)
sBeta_ab(data,param = est.par)
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey \cr
Updates and bug fixes by Sarah Pirikahu.
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions,
 volume 2, chapter 25, Wiley, New York.\cr
 \cr
 Bury, K. (1999) Statistical Distributions in Engineering, Chapter 14, pp.261-262,
 Cambridge University Press.
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}

