% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearize_image.R
\name{linearize_image}
\alias{linearize_image}
\title{Image linearization  (Linearizacao da imagem).}
\usage{
linearize_image(im,exclude=FALSE)
}
\arguments{
\item{im}{:Image object (Imagem com o objeto).}

\item{exclude}{:Logical value, if TRUE, pixels with zero will be excluded
(Valor logico, se for TRUE o valor zero sera excluido da matriz).}
}
\value{
Return images size (Retorna o tamanho das imagens).
}
\description{
This function linearize matrix image
(Esta funcao lineariza a imagem).
}
\examples{
im1=read_image(example_image(2),plot=TRUE)
B=gray_scale(im = im1,method = "b",plot=TRUE)
plot_image(B,col=3)
m=segmentation(B,treshold =0.38,selectHigher = FALSE,fillHull =TRUE,plot = TRUE )

Lin1=linearize_image(im =im1)
head(Lin1)
info_image(Lin1)

Lin2=linearize_image(im=m)
head(Lin2)
info_image(Lin2)

Lin3=linearize_image(im=m,exclude = TRUE)
head(Lin3)
info_image(Lin3)
}
\seealso{
\code{\link{gray_scale}} , \code{\link{read_image}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
