% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_graph.R
\name{import_graph}
\alias{import_graph}
\title{Import \code{EViews} graph objects(s) into R, R Markdown or Quarto.}
\usage{
import_graph(
  wf = "",
  page = "*",
  graph = "*",
  graph_procs = "",
  save_options = "",
  save_copy = T,
  save_path = dirname(wf)
)
}
\arguments{
\item{wf}{Object or a character string representing the name of an \code{EViews} workfile.}

\item{page}{Object or a character string representing the name of an \code{EViews} workfile page.}

\item{graph}{Name(s) or wildcard expressions of EViews graph object(S)}

\item{graph_procs}{A vector containing \code{EViews} graph \code{procs} such as \code{datelabel}, \code{align}}

\item{save_options}{A vector of options to be passed to \code{EViews} \code{save} command. It can take values like \code{"t=png"},\code{-c} and so on.}

\item{save_copy}{Logical. Whether to save the copy of the graph objects}

\item{save_path}{Object or a character string representing the path to the folder to save the \code{EViews} graphs. The current working directory is the default \code{save_path}. Specify the \code{save_path} only if you want the \code{EViews} graphs to live in different path from the current working directory.}
}
\value{
An EViews workfile
}
\description{
Use this function to import \code{EViews} graph objects(s) into R, R Markdown or Quarto.
}
\examples{
library(EviewsR)
\dontrun{
demo(exec_commands)

# To import all graph objects

import_graph(wf="exec_commands")

# To import only graphs that begin with x:

import_graph(wf="exec_commands",graph="x*")

# To access the graph objects in base R:

# eviewspage-x_graph # graph saved in "figure/" folder

# To get the graph objects in R Markdown or Quarto

# chunkLabel-eviewspage-x_graph # graph saved in "fig.path" folder

}
}
\seealso{
Other important functions: 
\code{\link{EviewsR}},
\code{\link{create_object}()},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_pagesave}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export_dataframe}()},
\code{\link{export}()},
\code{\link{import_equation}()},
\code{\link{import_kable}()},
\code{\link{import_series}()},
\code{\link{import_table}()},
\code{\link{import_workfile}()},
\code{\link{import}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\concept{important functions}
\keyword{documentation}
