/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.likelihood;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import org.apache.commons.math.util.FastMath;
import org.ohdsi.data.SortedCoxData;

public class CoxPartialLikelihood
extends AbstractModelLikelihood {
    private final Parameter beta;
    private final SortedCoxData data;
    private final int N;
    private final double numeratorConstant;
    private boolean likelihoodKnown;
    private boolean storedLikelihoodKnown;
    private double logLikelihood;
    private double storedLogLikelihood;

    public CoxPartialLikelihood(Parameter beta, SortedCoxData data) {
        super("coxPartialLikelihood");
        this.beta = beta;
        this.data = data;
        this.N = data.y.length;
        this.addVariable((Variable)beta);
        int[] y = data.y;
        double[] x = data.x;
        double sum = 0.0;
        int i = 0;
        while (i < this.N) {
            sum += y[i] == 1 ? x[i] : 0.0;
            ++i;
        }
        this.numeratorConstant = sum;
    }

    private double numeratorContribution() {
        return this.numeratorConstant * this.beta.getParameterValue(0);
    }

    private double denominatorContribution() {
        double[] weight = this.data.weight;
        double[] x = this.data.x;
        int[] strata = this.data.strata;
        double b = this.beta.getParameterValue(0);
        double sum = 0.0;
        int resetIndex = 0;
        double denominatorTotal = 0.0;
        int i = 0;
        while (i < this.N) {
            if (i == strata[resetIndex]) {
                denominatorTotal = 0.0;
                ++resetIndex;
            }
            double increment = weight[i] * FastMath.log((double)(denominatorTotal += FastMath.exp((double)(x[i] * b))));
            sum += increment;
            ++i;
        }
        return sum;
    }

    private double calculateLogLikelihood() {
        return this.numeratorContribution() - this.denominatorContribution();
    }

    protected void handleModelChangedEvent(Model model, Object o, int i) {
    }

    protected void handleVariableChangedEvent(Variable variable, int i, Variable.ChangeType changeType) {
        if (variable == this.beta) {
            this.likelihoodKnown = false;
        }
    }

    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    protected void acceptState() {
    }

    public Model getModel() {
        return this;
    }

    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    public static void main(String[] args) {
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        int[] y = nArray;
        double[] weight = new double[]{1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0};
        double[] x = new double[]{0.0, 2.0, 1.0, 1.0, 0.0, 0.0, 1.0};
        int[] strata = new int[]{4, 7};
        double beta = 1.205852;
        SortedCoxData data = new SortedCoxData(y, x, strata, weight);
        Parameter.Default parameter = new Parameter.Default(beta);
        CoxPartialLikelihood cox = new CoxPartialLikelihood((Parameter)parameter, data);
        System.err.println(cox.getLogLikelihood());
    }
}

