% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventStudyAPI.R
\name{EventStudyAPI}
\alias{EventStudyAPI}
\title{API for \url{https://www.eventstudytools.com}}
\format{
\code{\link[R6]{R6Class}} object
}
\description{
R interface for performing Event Studies on 
\url{https://www.eventstudytools.com}. 

For more details see the help vignette:
\code{vignette("introduction_eventstudy", package = "EventStudy")}
}
\section{Usage}{

For usage details see \bold{Methods, Arguments, and Examples} sections.
}

\section{Methods}{

\describe{
  \item{\code{new(apiServerUrl)}}{This method is used to create an
  object of this class with \code{apiServerUrl} as the url to the 
  EventStudyTools server}
  \item{\code{authentication(apiKey)}}{This method is used to 
  authenticate at \code{apiServerUrl}. A valid \code{APIkey} is 
  required. You can download a free key on our website: 
  \url{https://www.eventstudytools.com}}
  \item{\code{performEventStudy(estParam)}}{This method starts an Event Study. 
  This method does all the analysis work for you}
  \item{\code{performDefaultEventStudy()}}{This method starts a default 
  Event Study. It is a wrapper around \code{performEventStudy}}
  \item{\code{processTask()}}{This method starts the Event Study 
  calculation on the server (after files are uploaded.}
  \item{\code{configureTask(input)}}{This method configures the 
  Event Study. \code{input} is an \code{ApplicationInputInterface} 
  R6 object, e.g. ARC configuration class}
  \item{\code{uploadFile(fileKey, fileName)}}{This method links to the 
  file to upload. \code{fileKey} is the key of the file. Valid values 
  are: \code{request_file}, \code{firm_data}, and \code{market_data}. 
  \code{fileName} file name to upload.}
  \item{\code{commitData()}}{This method commits the data to the server}
  \item{\code{getTaskStatus()}}{Check if calculation is finished}
  \item{\code{getTaskResults(destDir = getwd())}}{Downloads the 
  result files of the Event Study to \code{destDir} (Default: current 
  working directory).}
  }
}

\section{Arguments}{

\describe{
 \item{eventstudyapi}{An \code{EventStudyAPI} object}
 \item{apiServerUrl}{URL to the API endpoint}
 \item{apiKey}{Key for authentication}
 \item{input}{An \code{ApplicationInputInterface} object.}
 \item{fileKey}{Type of input file: \code{request_file}, \code{firm_data}, 
 and \code{market_data}}
 \item{fileName}{Data filename}
 \item{destDir}{Directory for saving result files}
}
}

\examples{
\dontrun{
apiKey <- "{Please insert your aPI key here}"

The URL is already set by default
options(EventStudy.KEY = apiKey)

# initialize object
estSetup <- EventStudyAPI$new()

# get S&P500 example data
getSP500ExampleFiles()

# set Event Study parameters
estType <- "arc"
dataFiles <- c("request_file" = "01_RequestFile.csv", 
               "firm_data"    = "02_firmData.csv", 
               "market_data"  = "03_MarketData.csv")
resultPath <- "results"

# Perform Event Study 
estResult <- estSetup$performDefaultEventStudy(estType    = estType,
                                               dataFiles  = dataFiles, 
                                               destDir    = resultPath)
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{EventStudyAPI$new()}}
\item \href{#method-authentication}{\code{EventStudyAPI$authentication()}}
\item \href{#method-performEventStudy}{\code{EventStudyAPI$performEventStudy()}}
\item \href{#method-performDefaultEventStudy}{\code{EventStudyAPI$performDefaultEventStudy()}}
\item \href{#method-processTask}{\code{EventStudyAPI$processTask()}}
\item \href{#method-configureTask}{\code{EventStudyAPI$configureTask()}}
\item \href{#method-uploadFile}{\code{EventStudyAPI$uploadFile()}}
\item \href{#method-deleteFileParts}{\code{EventStudyAPI$deleteFileParts()}}
\item \href{#method-splitFile}{\code{EventStudyAPI$splitFile()}}
\item \href{#method-get_token}{\code{EventStudyAPI$get_token()}}
\item \href{#method-commitData}{\code{EventStudyAPI$commitData()}}
\item \href{#method-getTaskStatus}{\code{EventStudyAPI$getTaskStatus()}}
\item \href{#method-getTaskResults}{\code{EventStudyAPI$getTaskResults()}}
\item \href{#method-getApiVersion}{\code{EventStudyAPI$getApiVersion()}}
\item \href{#method-clone}{\code{EventStudyAPI$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$new(apiServerUrl = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-authentication"></a>}}
\if{latex}{\out{\hypertarget{method-authentication}{}}}
\subsection{Method \code{authentication()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$authentication(apiKey = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-performEventStudy"></a>}}
\if{latex}{\out{\hypertarget{method-performEventStudy}{}}}
\subsection{Method \code{performEventStudy()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$performEventStudy(
  estParams = NULL,
  dataFiles = c(request_file = "01_RequestFile.csv", firm_data = "02_firmData.csv",
    market_data = "03_MarketData.csv"),
  destDir = "results",
  downloadFiles = T,
  checkFiles = F
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-performDefaultEventStudy"></a>}}
\if{latex}{\out{\hypertarget{method-performDefaultEventStudy}{}}}
\subsection{Method \code{performDefaultEventStudy()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$performDefaultEventStudy(
  estType = "arc",
  dataFiles = c(request_file = "01_RequestFile.csv", firm_data = "02_firmData.csv",
    market_data = "03_MarketData.csv"),
  destDir = "results",
  downloadFiles = T,
  checkFiles = F
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-processTask"></a>}}
\if{latex}{\out{\hypertarget{method-processTask}{}}}
\subsection{Method \code{processTask()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$processTask()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-configureTask"></a>}}
\if{latex}{\out{\hypertarget{method-configureTask}{}}}
\subsection{Method \code{configureTask()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$configureTask(estParams = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-uploadFile"></a>}}
\if{latex}{\out{\hypertarget{method-uploadFile}{}}}
\subsection{Method \code{uploadFile()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$uploadFile(fileKey, fileName, partNumber = 0)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-deleteFileParts"></a>}}
\if{latex}{\out{\hypertarget{method-deleteFileParts}{}}}
\subsection{Method \code{deleteFileParts()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$deleteFileParts(parts)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-splitFile"></a>}}
\if{latex}{\out{\hypertarget{method-splitFile}{}}}
\subsection{Method \code{splitFile()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$splitFile(fileName, maxChunkSize)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_token"></a>}}
\if{latex}{\out{\hypertarget{method-get_token}{}}}
\subsection{Method \code{get_token()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$get_token()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-commitData"></a>}}
\if{latex}{\out{\hypertarget{method-commitData}{}}}
\subsection{Method \code{commitData()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$commitData()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTaskStatus"></a>}}
\if{latex}{\out{\hypertarget{method-getTaskStatus}{}}}
\subsection{Method \code{getTaskStatus()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$getTaskStatus(exceptionOnError = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTaskResults"></a>}}
\if{latex}{\out{\hypertarget{method-getTaskResults}{}}}
\subsection{Method \code{getTaskResults()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$getTaskResults(downloadFiles = T, destDir = getwd())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getApiVersion"></a>}}
\if{latex}{\out{\hypertarget{method-getApiVersion}{}}}
\subsection{Method \code{getApiVersion()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$getApiVersion()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EventStudyAPI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
