% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.evaluate.core.R
\name{pca.evaluate.core}
\alias{pca.evaluate.core}
\title{Principal Component Analysis}
\usage{
pca.evaluate.core(
  data,
  names,
  quantitative,
  selected,
  center = TRUE,
  scale = TRUE,
  npc.plot = 6
)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{center}{either a logical value or numeric-alike vector of length
    equal to the number of columns of \code{x}, where
    \sQuote{numeric-alike} means that \code{\link[base]{as.numeric}(.)} will
    be applied successfully if \code{\link[base]{is.numeric}(.)} is not true.}

\item{scale}{either a logical value or a numeric-alike vector of length
    equal to the number of columns of \code{x}.}

\item{npc.plot}{The number of principal components for which eigen values are
to be plotted. The default value is 6.}
}
\value{
A list with the following components. \item{EC PC Importance}{A data
  frame of importance of principal components for EC} \item{EC PC Loadings}{A
  data frame with eigen vectors of principal components for EC} \item{CS PC
  Importance}{A data frame of importance of principal components for CS}
  \item{CS PC Loadings}{A data frame with eigen vectors of principal
  components for CS} \item{Scree Plot}{The scree plot of principal components
  for EC and CS as a \code{ggplot} object.} \item{PC Loadings Plot}{A plot of
  the eigen vector values of principal components for EC and CS as specified
  by \code{npc.plot} as a \code{ggplot2} object.}
}
\description{
Compute Principal Component Analysis Statistics
\insertCite{mardia_multivariate_1979}{EvaluateCore} to compare the
probability distributions of quantitative traits between entire collection
(EC) and core set (CS).
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

pca.evaluate.core(data = ec, names = "genotypes",
                  quantitative = quant, selected = core,
                  center = TRUE, scale = TRUE, npc.plot = 4)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{prcomp}}
}
