% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Bonds_List.R
\name{EN_Bonds_List}
\alias{EN_Bonds_List}
\title{Get the list of Bonds quoted on Euronext markets}
\usage{
EN_Bonds_List(tot_page = 5)
}
\arguments{
\item{tot_page}{Total number of pages to retrieve. It can be a numerical value, 'Max' to designate the maximum number of pages, or the default value is 5.}
}
\value{
A data frame containing information about Bonds, including name, ticker, ISIN code, market, last price, percentage change, and URL.
}
\description{
This function retrieves information about Bonds quoted on Euronext markets.
}
\examples{

\donttest{
library(httr)
library(jsonlite)
library(rvest)
library(stringr)

dt_ = EN_Bonds_List(10) # To show only 10 pages
print(dt_)

dt_ = EN_Bonds_List()  # To show only 5 pages by defaut
print(dt_)

# dt_ = EN_Bonds_List('Max') #To show all the bonds list
# print(dt_)
}

}
\seealso{
\code{\link{EN_Stocks_List}} to get the list tickers infos quoted on a given Euronext Stock,
\code{\link{EN_Funds_List}} for Funds list,  \code{\link{EN_Indices_List}} for Indexes list,
\code{\link{EN_Etfs_List}}  for Etfs list

Other Infos Retrieval: 
\code{\link{EN_Bonds_List_bis}()},
\code{\link{EN_Etfs_List_bis}()},
\code{\link{EN_Etfs_List}()},
\code{\link{EN_Funds_List}()},
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_Etf}()},
\code{\link{EN_GetISIN_F}()},
\code{\link{EN_Get_News}()},
\code{\link{EN_Indices_List}()},
\code{\link{EN_Stocks_List}()},
\code{\link{En_Market.Sumarry}()}
}
\concept{Infos Retrieval}
