% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_clim_data.R
\name{extract_clim_data}
\alias{extract_clim_data}
\title{Extract Climate Data}
\usage{
extract_clim_data(climdat, locations, id = FALSE)
}
\arguments{
\item{climdat}{A SpatRaster, RasterStack or RaterLayer of the climate data to extract.}

\item{locations}{An object specifying location of where to extract the climate data from. Can be a SpatialPolygosDataFrame, SpatialPolygons, SpatVector, a single data.frame or a list of data.frames. If data.frame of list of data.frames, must provide only two columns with column names "lon" for longitude and "lat" for latitude.}

\item{id}{Choose to include cell numbers with climate data. 'TRUE' includes cell numbers, the default 'FALSE' does not include cell numbers. Used in the climatch_plot() function.}
}
\value{
A data.frame or list of data.frames of the extracted climate data.
}
\description{
Extracts climate data from several types of inputs.
}
\examples{
# Create fake climate data in as a SpatRaster object
r1 <- data.frame()
for(i in 1:100){r1 <- rbind(r1, runif(60))}
rclim1 <- terra::rast(as(r1, "matrix")) #Create the RasterLayer
rclim2 <- c(rclim1, rclim1) # Create the stack

# Dummy lon lat data i.e., species occurrences. Cols must be labelled "lon" and "lat"
# Cols must be labelled "lon" and "lat"
species.occurr <- data.frame("lon" = 1:10, "lat" = 11:20)

# Create dummy polygons
x.coor <- c(1, 5,  10, 8, 3)
y.coor <- c(15, 20,  27, 30, 29)
dummy_coordinates <- cbind(x.coor, y.coor)
dummy_polygon <- terra::vect(dummy_coordinates, type = "polygon")
dummy_polygon2 <- rbind(dummy_polygon, dummy_polygon)

# Extract the dummy data
# Extract dummy lon lat data
extract_clim_data(climdat = rclim2, locations = species.occurr)
# Extract dummy SpatVector with single polygon
extract_clim_data(climdat = rclim2, locations = dummy_polygon2)
}
