% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discouraged_functions.R
\name{plotAge}
\alias{plotAge}
\title{Age bar graph}
\usage{
plotAge(
  .data,
  xvar = "XLabel",
  yvar = "YValue",
  fill_color1 = "#65B32E",
  ytitle = "Rate"
)
}
\arguments{
\item{.data}{dataframe containing the variables to plot}

\item{xvar}{character string, name of the variable to plot on the x-axis in quotes
(default \code{"XLabel"})}

\item{yvar}{character string, name of the variable to plot on the y-axis in quotes
(default \code{"YValue"})}

\item{fill_color1}{character string, hexadecimal colour to use in the graph;
(default to ECDC green \code{"#65B32E"}, see EcdcColors(col_scale = "qual", n = 1))}

\item{ytitle}{character string, y-axis title; (default \code{"Rate"}).}
}
\description{
(Discouraged function. Please use \code{plotBarGrouped()} instead.)
}
\details{
This function draws a bar graph by age group (or possibly other grouping). \cr
The bar graph presents the distribution of cases at EU/EEA level
using the rate per 100 000 cases by age. \cr
Expects aggregated data.
}
\examples{

# --- Create dummy data
mydat <- data.frame(AgeGroup = c("0-25", "26-65", "65+"),
                    NumberOfCases = c(54,32,41))

# --- Plot the dummy data
plotAge(mydat,
        xvar = "AgeGroup",
        yvar = "NumberOfCases",
        ytitle = "Number of cases")

}
\seealso{
Global function: \code{\link{getAgeGender}}  \cr
Internal function: \code{\link{EcdcColors}} \cr
Required Packages: \code{\link{ggplot2}}
}
\keyword{age}
\keyword{bargraph}
