% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_quasinum.R
\name{orderQuasinum}
\alias{orderQuasinum}
\title{Order 'quasinumerical' categorical vectors (increasing order)}
\usage{
orderQuasinum(x)
}
\arguments{
\item{x}{character vector with 'quasinumerical' values}
}
\description{
A function to order 'quasinumerical' (i.e. categorical with values
such as "15-30" or "<18") integer vectors into increasing order.
Currently handles away the following non-numerical characters
"-", ">", "<", ">=", "<=", "+".
}
\examples{
age1 <- c("<1", "1-15", "16-25", ">65", "26-65")
age2 <- c("0-4", "5-10", ">65", "25-64", "11-25")
age3 <- c("5-10", ">65", "25-64", "11-25", "<=4")
age4 <- c(">=65", "<18", "18-64")
age5 <- c("5-10", "+65", "25-64", "11-25", "0-4")

age1
orderQuasinum(age1)
age2
orderQuasinum(age2)
age3
orderQuasinum(age3)
age4
orderQuasinum(age4)
age5
orderQuasinum(age5)

}
\seealso{
Used in \code{\link{getAgeGender}} and \code{\link{plotAgeGender}} / \code{\link{plotAge}}
}
\author{
Tommi Karki
}
\keyword{order}
